"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateGroup = validateGroup;
const joi_1 = __importDefault(require("joi"));
const api_response_1 = require("../api.response");
const logger_service_1 = require("../service/logger.service");
const common_service_1 = require("../service/common.service");
function validateGroup(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e, _f;
        try {
            const requestField = {
                groupName: (_a = req === null || req === void 0 ? void 0 : req.body) === null || _a === void 0 ? void 0 : _a.groupName,
                ageGroup: (_b = req === null || req === void 0 ? void 0 : req.body) === null || _b === void 0 ? void 0 : _b.ageGroup,
                subscriptionPlan: (_c = req === null || req === void 0 ? void 0 : req.body) === null || _c === void 0 ? void 0 : _c.subscriptionPlan,
                transcribeUsageRange: (_d = req === null || req === void 0 ? void 0 : req.body) === null || _d === void 0 ? void 0 : _d.transcribeUsageRange,
                users: (_e = req === null || req === void 0 ? void 0 : req.body) === null || _e === void 0 ? void 0 : _e.users,
                status: (_f = req === null || req === void 0 ? void 0 : req.body) === null || _f === void 0 ? void 0 : _f.status,
            };
            const schema = joi_1.default.object({
                groupName: joi_1.default.string()
                    .min(2)
                    .max(100)
                    .required()
                    .messages(api_response_1.validationMessages.groupName),
                ageGroup: joi_1.default.object({
                    minAge: joi_1.default.number()
                        .integer()
                        .min(0)
                        .required()
                        .messages(api_response_1.validationMessages.minAge),
                    maxAge: joi_1.default.number()
                        .integer()
                        .min(joi_1.default.ref("minAge"))
                        .required()
                        .messages(api_response_1.validationMessages.maxAge),
                })
                    .required()
                    .messages(api_response_1.validationMessages.groupAge),
                subscriptionPlan: joi_1.default.array()
                    .items(joi_1.default.string().hex().length(24))
                    .messages(api_response_1.validationMessages.subscriptionPlan),
                transcribeUsageRange: joi_1.default.object({
                    minUsage: joi_1.default.number().required().messages(api_response_1.validationMessages.minUsage),
                    maxUsage: joi_1.default.number().required().messages(api_response_1.validationMessages.maxUsage),
                })
                    .required()
                    .messages(api_response_1.validationMessages.transcribeUsageRange),
                users: joi_1.default.array()
                    .items(joi_1.default.string().hex().length(24))
                    .messages(api_response_1.validationMessages.users),
                status: joi_1.default.boolean().required().messages(api_response_1.validationMessages.status),
            }).options({ abortEarly: false });
            const { error } = schema.validate(requestField);
            if (error) {
                const errorMessages = error.details.map((err) => {
                    var _a;
                    return ({
                        field: (_a = err === null || err === void 0 ? void 0 : err.context) === null || _a === void 0 ? void 0 : _a.key,
                        message: err.message.replace(/"/g, ""), // Remove the extra quotes
                    });
                });
                return yield (0, common_service_1.sendValidationMessageResponse)(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.BadRequest, errorMessages);
            }
            next();
        }
        catch (error) {
            console.log("Getting error while check group validation:", error);
            logger_service_1.logger.error(`Getting error while check group validation : ${error}`);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.error);
        }
    });
}
