"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importDefault(require("mongoose"));
const utills_1 = require("../../service/utills");
const userSchema = new mongoose_1.default.Schema({
    // username: {
    //   type: String,
    //   required: true,
    //   min: 3,
    //   max: 100,
    // },
    email: {
        type: String,
        required: true,
        min: 5,
        max: 255,
    },
    password: {
        type: String,
        min: 3,
        max: 100,
    },
    role: {
        type: mongoose_1.default.Types.ObjectId,
        null: false,
        ref: "role",
    },
    userType: {
        type: String,
        enum: [utills_1.USER_TYPE.SUPER_ADMIN, utills_1.USER_TYPE.SUB_ADMIN, utills_1.USER_TYPE.USER],
        required: true,
        default: utills_1.USER_TYPE.USER,
    },
    otp: {
        type: String,
    },
    otpSentTime: {
        type: Date,
    },
    status: {
        type: Boolean,
        default: true,
    },
    isDeleted: {
        type: Boolean,
        default: false,
    },
});
exports.default = mongoose_1.default.model("users", userSchema);
