"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addTranscriptionQuality = addTranscriptionQuality;
exports.updateTranscriptionQuality = updateTranscriptionQuality;
exports.getTranscriptionQuality = getTranscriptionQuality;
exports.deleteTranscriptionQuality = deleteTranscriptionQuality;
exports.getTranscriptionQualityById = getTranscriptionQualityById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const transcriptionQuality_entity_1 = __importDefault(require("../entities/transcriptionQuality.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//============= ADD A NEW TRANSCRIPTION QUALITY ======================/
function addTranscriptionQuality(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { newTranscriptionQuality, status } = req.body;
        if (!newTranscriptionQuality) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingUser = yield transcriptionQuality_entity_1.default.findOne({
                newTranscriptionQuality,
                isDeleted: false,
            });
            if (existingUser) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.transcriptionQuality.transcriptionQualityExits);
            }
            else {
                const savedRole = yield transcriptionQuality_entity_1.default.create({
                    newTranscriptionQuality,
                    status,
                });
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.transcriptionQuality.success, savedRole);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add transcription quality: ${error}`);
            console.log("Getting error while add transcription quality: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//============= UPDATE A TRANSCRIPTION QUALITY ======================/
function updateTranscriptionQuality(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { newTranscriptionQuality, status, _id } = req.body;
        try {
            const updatedTranscriptionQuality = yield transcriptionQuality_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { newTranscriptionQuality, status }, { new: true });
            if (!updatedTranscriptionQuality) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.transcriptionQuality.transcriptionQualityNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.transcriptionQuality.transcriptionQualityUpdated, updatedTranscriptionQuality);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while update transcription quality: ${error}`);
            console.log("Getting error while update transcription quality: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//============= GET ALL TRANSCRIPTION QUALITY ======================/
function getTranscriptionQuality(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take } = query;
            let searchQuery = {};
            if (search) {
                searchQuery = {
                    $or: [{ newTranscriptionQuality: new RegExp(search, "i") }],
                };
            }
            let filters = { isDeleted: false };
            const options = {
                searchQuery,
                filter: filters,
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(transcriptionQuality_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: data || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get transcription qualityes: ${error}`);
            console.log("Getting error while get transcription qualityes: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//============= DELETE TRANSCRIPTION QUALITY ======================/
function deleteTranscriptionQuality(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield transcriptionQuality_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(id), isDeleted: false }, { isDeleted: true });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.transcriptionQuality.transcriptionQualityDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while delete transcription quality: ${error}`);
            console.log("Getting error while delete transcription quality: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//============= GET TRANSCRIPTION QUALITY BY ID======================/
function getTranscriptionQualityById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const transcriptionQuality = yield transcriptionQuality_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!transcriptionQuality) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.transcriptionQuality.transcriptionQualityNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, transcriptionQuality);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get transcription quality by id: ${error}`);
            console.error("Getting error while get transcription quality by id: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
