"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddSupportRequest = AddSupportRequest;
const common_service_1 = require("../../service/common.service");
const api_response_1 = require("../../api.response");
const supportRequest_entity_1 = __importDefault(require("../entities/supportRequest.entity"));
const logger_service_1 = require("../../service/logger.service");
function AddSupportRequest(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { title, description } = req.body;
            const userInfo = (0, common_service_1.getTokenUserInfo)(req);
            if (!title || !description) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
            }
            const existingSupportRequest = yield supportRequest_entity_1.default.findOne({
                title,
            });
            if (existingSupportRequest) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.supportRequest.supportRequestExits);
            }
            else {
                const savedSupportRequest = yield supportRequest_entity_1.default.create({
                    title,
                    description,
                });
                // const emailSent = await sendEmail({
                //   userEmail: userInfo.email,
                //   subject: savedSupportRequest.title,
                //   text: ``,
                //   html: `<p>${savedSupportRequest.description}</p>`,
                // });
                // if (!emailSent) {
                //   return sendMessageResponse(
                //     req,
                //     res,
                //     StatusCode.InternalServerError,
                //     "Error sending verification email"
                //   );
                // }
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.supportRequest.success, savedSupportRequest);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add support request  : ${error}`);
            console.log("Getting error while add support request :", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
