"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const privacyPolicy_1 = require("../privacy-policy/controllers/privacyPolicy");
const privacyPolicy_validator_1 = require("../validators/privacyPolicy.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const privacyPolicyRoute = express_1.default.Router();
privacyPolicyRoute.get("/privacy-policy", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("privacyPolicy", "isView"), privacyPolicy_1.getPrivacyPolicy);
privacyPolicyRoute.patch("/privacy-policy", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("privacyPolicy", "isEdit"), privacyPolicy_validator_1.validatePrivacyPolicy, privacyPolicy_1.updatePrivacyPolicy);
exports.default = privacyPolicyRoute;
