"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const verifyjwt_1 = require("../middleware/verifyjwt");
const inputFile_1 = require("../input-file/controllers/inputFile");
const common_service_1 = require("../service/common.service");
const multer_1 = require("../helpers/multer");
const inputRoute = express_1.default.Router();
inputRoute.post("/input-file/createBatch", verifyjwt_1.verifyjwt, inputFile_1.createBatch);
inputRoute.post("/input-file/add", verifyjwt_1.verifyjwt, (0, multer_1.uploadMultipleFile)("public/input-file", "inputFile", 10), common_service_1.validFileType, inputFile_1.add);
inputRoute.post("/input-file/editInputFile", verifyjwt_1.verifyjwt, inputFile_1.editInputFile);
inputRoute.post("/input-file/youTubeUpload", verifyjwt_1.verifyjwt, inputFile_1.youTubeUpload);
inputRoute.post("/input-file/outPutFile", verifyjwt_1.verifyjwt, inputFile_1.exportOutPutFile);
inputRoute.get("/input-file/get", verifyjwt_1.verifyjwt, inputFile_1.get);
inputRoute.get("/output-file/getAllOutPutFile", verifyjwt_1.verifyjwt, inputFile_1.getAllOutPutFile);
inputRoute.get("/input-file/:id", verifyjwt_1.verifyjwt, inputFile_1.getById);
inputRoute.post("/input-file/delete", verifyjwt_1.verifyjwt, inputFile_1.deleteFiles);
inputRoute.post("/thematicAnalytic", verifyjwt_1.verifyjwt, inputFile_1.thematicAnalytic);
// inputRoute.get("/exportPDF", verifyjwt, exportPDF);
inputRoute.post("/input-file/add-recording", verifyjwt_1.verifyjwt, (0, multer_1.uploadMultipleFile)("public/input-file", "inputFile", 10), common_service_1.validFileType, inputFile_1.addRecordedFile);
exports.default = inputRoute;
