"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addOutputFormat = addOutputFormat;
exports.updateOutputFormat = updateOutputFormat;
exports.getOutputFormats = getOutputFormats;
exports.deleteOutputFormat = deleteOutputFormat;
exports.getOutputFormatById = getOutputFormatById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const outputFormat_entity_1 = __importDefault(require("../entities/outputFormat.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//==================== ADD A NEW OUTPUT FORMAT ================//
function addOutputFormat(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { uploadNewFormat, status } = req.body;
        if (!uploadNewFormat) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingOutputFormat = yield outputFormat_entity_1.default.findOne({
                uploadNewFormat,
                isDeleted: false,
            });
            if (existingOutputFormat) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.outputFormat.outputFormatExits);
            }
            else {
                const savedOutputFormatData = yield outputFormat_entity_1.default.create({
                    uploadNewFormat,
                    status,
                });
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.outputFormat.success, savedOutputFormatData);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add output format : ${error}`);
            console.log("Getting error while add output format :", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== UPDATE  A EXISTING OUTPUT FORMAT ================//
function updateOutputFormat(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { uploadNewFormat, status, _id } = req.body;
        try {
            const updatedOutputFormat = yield outputFormat_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { uploadNewFormat, status }, { new: true });
            if (!updatedOutputFormat) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.outputFormat.outputFormatNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.outputFormat.outputFormatUpdated, updatedOutputFormat);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while update output format : ${error}`);
            console.log("Getting error while update output format :", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET ALL OUTPUT FORMAT ================//
function getOutputFormats(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take } = query;
            const searchQuery = search
                ? { uploadNewFormat: new RegExp(search, "i") }
                : {};
            let filters = { isDeleted: false };
            const options = {
                searchQuery,
                filter: filters,
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(outputFormat_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: data || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Error while fetching output formats: ${error}`);
            console.log("Error while fetching output formats:", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== DELETE A  OUTPUT FORMAT ================//
function deleteOutputFormat(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield outputFormat_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(id), isDeleted: false }, { isDeleted: true });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.outputFormat.outputFormatDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while delete output format: ${error}`);
            console.log("Getting error while delete output format: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET OUTPUT FORMAT BY ID ================//
function getOutputFormatById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const outputFormat = yield outputFormat_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!outputFormat) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.outputFormat.outputFormatNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, outputFormat);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get output format by id: ${error}`);
            console.error("Getting error while get output format by id :", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
