"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.loggerMiddleware = exports.logRequest = void 0;
exports.getApiLogs = getApiLogs;
const common_service_1 = require("../../service/common.service");
const api_response_1 = require("../../api.response");
const logs_entity_1 = __importDefault(require("../entities/logs.entity"));
function getApiLogs(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { search, page, take, role } = req.query;
            let userInfo = (0, common_service_1.getTokenUserInfo)(req);
            let searchQuery = { _id: { $ne: userInfo._id } };
            if (search) {
                searchQuery = {
                    $or: [{ email: new RegExp(search, "i") }],
                };
            }
            let filters = {};
            if (role)
                filters.role = role;
            const options = {
                searchQuery,
                filter: filters,
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(logs_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, {
                data: data,
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            });
        }
        catch (error) {
            console.log("Getting error while add user & signUp", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
const logRequest = (req, res, status, responseTime) => __awaiter(void 0, void 0, void 0, function* () {
    const log = new logs_entity_1.default({
        method: req.method,
        url: req.originalUrl,
        status: status,
        responseTime: responseTime,
    });
    try {
        yield log.save();
    }
    catch (err) {
        console.error("Error saving log:", err);
    }
});
exports.logRequest = logRequest;
const loggerMiddleware = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const start = Date.now();
    res.on("finish", () => __awaiter(void 0, void 0, void 0, function* () {
        const log = new logs_entity_1.default({
            method: req.method,
            url: req.originalUrl,
            status: res.StatusCode,
            responseTime: Date.now() - start,
            title: (0, common_service_1.convertUrlToTitle)(req.originalUrl),
        });
        try {
            yield log.save();
        }
        catch (err) {
            console.error("Error saving log:", err);
        }
    }));
    next();
});
exports.loggerMiddleware = loggerMiddleware;
