"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.inputFile = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const inputFileSchema = new mongoose_1.default.Schema({
    file: {
        type: [Object],
    },
    batchName: {
        type: String,
        default: null,
    },
    amount: {
        type: Number,
    },
    userId: {
        type: mongoose_1.default.Types.ObjectId,
    },
    // NEW ADDITIONS IN CONTENT PRO
    users: [
        {
            type: mongoose_1.default.Types.ObjectId,
        },
    ],
    owner: {
        type: mongoose_1.default.Types.ObjectId,
    },
    workspaceId: {
        type: mongoose_1.default.Types.ObjectId,
        ref: "Workspace",
    },
    isRecorded: {
        type: Boolean,
        default: false,
    },
    transcriptionId: {
        type: String,
    },
}, {
    timestamps: true,
});
exports.inputFile = mongoose_1.default.model("input-file", inputFileSchema);
