"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validationMessages = exports.messages = exports.StatusCode = void 0;
exports.StatusCode = {
    Ok: 200,
    Create: 201,
    Deleted: 204,
    BadRequest: 400,
    Unauthorized: 401,
    InternalServerError: 500,
    NotFound: 404,
    TooManyConnection: 429,
};
exports.messages = {
    signIn: {
        success: "Sign in successful!",
        invalidCredentials: "Invalid email or password. Please try again.",
        accountLocked: "Your account has been locked. Please contact support.",
        otpSent: "OTP sent.",
        otpSentFail: "Failed to send email. Please try again",
    },
    signUp: {
        success: "Sign up successful!",
        emailTaken: "Email already in use.",
        weakPassword: "Password must be at least 8 characters long.",
    },
    updateUser: {
        success: "User updated successfully.",
        userNotFound: "User not found.",
    },
    verifyOTP: {
        success: "OTP verified successfully.",
        invalidOTP: "Invalid OTP.",
    },
    resendOTP: {
        tooSoon: "Try again after some time.",
    },
    resetPassword: {
        success: "Password updated successfully.",
        invalidToken: "Invalid token.",
    },
    user: {
        success: "User added successfully.",
        invalidToken: "Invalid token.",
    },
    role: {
        success: "Role added successfully.",
        roleExits: "Role already exists.",
        usedRole: "The Role is already in use",
        roleNotFound: "Role not found.",
        roleUpdated: "Role updated successfully.",
        roleDeleted: "Role deleted successfully.",
    },
    language: {
        success: "Language added successfully.",
        languageExits: "Language already exists.",
        languageNotFound: "Language not found.",
        languageUpdated: "Language updated successfully.",
        languageDeleted: "Language deleted successfully.",
    },
    transcriptionQuality: {
        success: "Transcription quality added successfully.",
        transcriptionQualityExits: "Transcription quality already exists.",
        transcriptionQualityNotFound: "Transcription quality not found.",
        transcriptionQualityUpdated: "Transcription quality updated successfully.",
        transcriptionQualityDeleted: "Transcription quality deleted successfully.",
    },
    audioPlayback: {
        success: "Audio playback added successfully.",
        audioPlaybackExits: "Audio playback already exists.",
        audioPlaybackNotFound: "Audio playback not found.",
        audioPlaybackUpdated: "Audio playback updated successfully.",
        audioPlaybackDeleted: "Audio playback deleted successfully.",
    },
    transcriptionCategory: {
        success: "Transcription category added successfully.",
        transcriptionCategoryExits: "Transcription category already exists.",
        transcriptionCategoryNotFound: "Transcription category not found.",
        transcriptionCategoryUpdated: "Transcription category updated successfully.",
        transcriptionCategoryDeleted: "Transcription category deleted successfully.",
    },
    subscription: {
        success: "Subscription added successfully.",
        subscriptionExits: "Subscription already exists.",
        subscriptionNotFound: "Subscription not found.",
        subscriptionUpdated: "Subscription updated successfully.",
        subscriptionDeleted: "Subscription deleted successfully.",
    },
    notification: {
        success: "Notification added successfully.",
        notificationExits: "Notification already exists.",
        notificationNotFound: "Notification not found.",
        notificationUpdated: "Notification updated successfully.",
        notificationDeleted: "Notification deleted successfully.",
    },
    group: {
        success: " Group added successfully.",
        groupExits: "Group already exists.",
        groupNotFound: "Group not found.",
        groupUpdated: "Group updated successfully.",
        groupDeleted: "Group deleted successfully.",
    },
    companySetting: {
        companySettingNotFound: "Company Setting not found.",
        companySettingpUpdated: "Company Setting updated successfully.",
    },
    privacyPolicy: {
        privacyPolicyNotFound: "Privacy Policy not found.",
        privacyPolicyUpdated: "Privacy Policy updated successfully.",
    },
    termsCondition: {
        termsConditionNotFound: "Terms Condition not found.",
        termsConditionUpdated: "Terms Condition updated successfully.",
    },
    outputFormat: {
        success: "Output Format added successfully.",
        outputFormatExits: "Output Format already exists.",
        outputFormatNotFound: "Output Format not found.",
        outputFormatUpdated: "Output Format updated successfully.",
        outputFormatDeleted: "Output Format deleted successfully.",
    },
    duration: {
        success: "Duration added successfully.",
        durationUpdated: "Duration updated successfully.",
        durationNotFound: "Please add duration",
    },
    changePassword: {
        success: "Password updated successfully.",
    },
    faqs: {
        success: "Faq added successfully.",
        faqExits: "Faq already exists.",
        faqNotFound: "Faq not found.",
        faqUpdated: "Faq updated successfully.",
        faqDeleted: "Faq deleted successfully.",
    },
    workspace: {
        success: "Workspace added successfully.",
        workspaceExists: "Workspace already exists.",
        workspaceNotFound: "Workspace not found.",
        workspaceUpdated: "Workspace updated successfully.",
        workspaceDeleted: "Workspace deleted successfully.",
    },
    ticket: {
        success: "Ticket added successfully.",
        ticketExits: "Ticket already exists.",
        ticketNotFound: "Ticket not found.",
        ticketUpdated: "Ticket updated successfully.",
        ticketDeleted: "Ticket deleted successfully.",
    },
    ticketSubject: {
        success: "Ticket Subject added successfully.",
        ticketSubjectExits: "Ticket Subject already exists.",
        ticketSubjectNotFound: "Ticket Subject not found.",
        ticketSubjectUpdated: "Ticket Subject updated successfully.",
        ticketSubjectDeleted: "Ticket Subject deleted successfully.",
    },
    inputFile: {
        uploadFile: "File Upload successfully",
        filesFetch: "Files data fetch successfully.",
        filesDeleted: "Files deleted successfully.",
    },
    supportRequest: {
        success: "Support Request added successfully.",
        supportRequestExits: "Support Request already exists.",
        supportRequestNotFound: "Support Request not found.",
        supportRequestUpdated: "Support Request updated successfully.",
        supportRequestDeleted: "Support Request deleted successfully.",
    },
    feedback: {
        success: "Feedback successfully.",
    },
    industry: {
        success: "Industry added successfully.",
        exists: "Industry already exists.",
        notFound: "Industry not found.",
        updated: "Industry updated successfully.",
        deleted: "Industry deleted successfully.",
    },
    yourRole: {
        success: "Role added successfully.",
        exists: "Role already exists.",
        notFound: "Role not found.",
        updated: "Role updated successfully.",
        deleted: "Role deleted successfully.",
    },
    allFieldsRequired: "All fields are required.",
    internalServerError: "Internal server error.",
    noUsersFound: "No users found.",
    success: "Data fetched successfully.",
    delete: "Data deleted successfully.",
    invalidToken: "Invalid token.",
    unauthorizedUser: "Unauthorized user.",
    noDataAvailable: "No data available.",
    insufficient_Permissions: "Unauthorized: Insufficient permissions",
    incorrectPassword: "Incorrect Password",
    maxFile: "Maximum 10 file allowed to upload",
    verifyProfile: "Please verify your profile",
    // ERRORS
    error: "Something went wrong.",
    recordError: "Record not found.",
    failUploadFile: "Failed to upload file.",
    logged_out: "You've been logged out successfully!",
    invalid_token: "Invalid Token.",
};
exports.validationMessages = {
    firstName: {
        "string.firstName": "Invalid firstname format",
        "any.required": "First Name is required",
    },
    lastName: {
        "string.lastName": "Invalid lastname format",
        "any.required": "Last Name is required",
    },
    email: {
        "string.email": "Invalid email format",
        "any.required": "Email is required",
    },
    password: {
        "string.pattern.base": "Password must contain only alphanumeric characters",
        "any.required": "Password is required",
    },
    profileImage: {
        "any.required": "Profile is required",
    },
    role: {
        "any.required": "Role is required",
    },
    status: {
        "any.required": "Status is required",
    },
    roleName: {
        "any.required": "Role name is required",
    },
    userId: {
        "any.required": "User Id is required",
    },
    permission: {
        "any.required": "Permission is required",
    },
    newLanguage: {
        "any.required": "Language is required",
    },
    newTranscriptionQuality: {
        "any.required": "Transcription Quality is required",
    },
    newAudioPlayback: {
        "any.required": "Audio Playback is required",
    },
    newTranscriptionCategory: {
        "any.required": "Transcription Category is required",
    },
    subscriptionTitle: {
        "any.required": "Subscription Title is required",
    },
    planDuration: {
        "any.required": "Plan Duration is required",
    },
    subscriptionAmount: {
        "any.required": "Subscription Amount is required",
    },
    startDate: {
        "date.base": "Start date should be a valid date",
        "date.empty": "Start date cannot be empty",
        "date.isoDate": "Start date must be in ISO format",
        "any.required": "Start date is required",
    },
    endDate: {
        "date.base": "End date should be a valid date",
        "date.empty": "End date cannot be empty",
        "date.isoDate": "End date must be in ISO format",
        "date.greater": "End date must be later than start date",
        "any.required": "End date is required",
    },
    title: {
        "any.required": "Title is required",
    },
    groupId: {
        "any.required": "Group Id is required",
    },
    message: {
        "any.required": "Message is required",
    },
    notificationType: {
        "any.required": "Notification Type is required",
    },
    userType: {
        "any.required": "User Type is required",
    },
    phone: {
        "any.required": "Phone is required",
    },
    url: {
        "any.required": "Url is required",
    },
    privacyPolicy: {
        "any.required": "Privacy Policy is required",
    },
    termsCondition: {
        "any.required": "Terms Condition is required",
    },
    groupName: {
        "any.required": "Group Name is required",
    },
    groupAge: {
        "any.required": "Group Age is required",
    },
    minAge: {
        "any.required": "Min Age is required",
    },
    maxAge: {
        "any.required": "Max Age is required",
    },
    subscriptionPlan: {
        "any.required": "Subscription Plan is required",
    },
    transcribeUsageRange: {
        "any.required": "Usage is required",
    },
    minUsage: {
        "any.required": "Min Usage is required",
    },
    maxUsage: {
        "any.required": "Max Usage is required",
    },
    users: {
        "any.required": "Users is required",
    },
    subscriptionContent: {
        "any.required": "Subscription Content is required",
    },
    companyAddress: {
        "any.required": "Company Address is required",
    },
    companyImage: {
        "any.required": "Company Profile is required",
    },
    subTitle: {
        "any.required": "Sub Title is required",
    },
    description: {
        "any.required": "Description is required",
    },
    subjectName: {
        "any.required": "Subject Name is required",
    },
    name: {
        "any.required": "Name is required",
    },
};
