"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateCompanySetting = validateCompanySetting;
const joi_1 = __importDefault(require("joi"));
const api_response_1 = require("../api.response");
const logger_service_1 = require("../service/logger.service");
const common_service_1 = require("../service/common.service");
function validateCompanySetting(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e;
        try {
            const requestField = {
                companyName: (_a = req === null || req === void 0 ? void 0 : req.body) === null || _a === void 0 ? void 0 : _a.companyName,
                emailId: (_b = req === null || req === void 0 ? void 0 : req.body) === null || _b === void 0 ? void 0 : _b.emailId,
                mobileNumber: (_c = req === null || req === void 0 ? void 0 : req.body) === null || _c === void 0 ? void 0 : _c.mobileNumber,
                url: (_d = req === null || req === void 0 ? void 0 : req.body) === null || _d === void 0 ? void 0 : _d.url,
                companyAddress: (_e = req === null || req === void 0 ? void 0 : req.body) === null || _e === void 0 ? void 0 : _e.companyAddress,
            };
            const schema = joi_1.default.object({
                companyName: joi_1.default.string()
                    .min(2)
                    .max(100)
                    .required()
                    .messages(api_response_1.validationMessages.newAudioPlayback),
                emailId: joi_1.default.string()
                    .min(5)
                    .max(255)
                    .required()
                    .email()
                    .messages(api_response_1.validationMessages.email),
                mobileNumber: joi_1.default.number()
                    .min(10)
                    .required()
                    .messages(api_response_1.validationMessages.phone),
                url: joi_1.default.string().messages(api_response_1.validationMessages.url),
                companyAddress: joi_1.default.string().messages(api_response_1.validationMessages.companyAddress),
            }).options({ abortEarly: false });
            const { error } = schema.validate(requestField);
            if (error) {
                const errorMessages = error.details.map((err) => {
                    var _a;
                    return ({
                        field: (_a = err === null || err === void 0 ? void 0 : err.context) === null || _a === void 0 ? void 0 : _a.key,
                        message: err.message.replace(/"/g, ""), // Remove the extra quotes
                    });
                });
                return yield (0, common_service_1.sendValidationMessageResponse)(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.BadRequest, errorMessages);
            }
            next();
        }
        catch (error) {
            console.log("Getting error while check company setting validation:", error);
            logger_service_1.logger.error(`Getting error while check company setting validation : ${error}`);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.error);
        }
    });
}
