"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const checkPermission_1 = require("../middleware/checkPermission");
const industry_validator_1 = require("../validators/industry.validator");
const industry_1 = require("../user-options/controllers/industry");
const upload_1 = require("../middleware/upload");
const file_validator_1 = require("../validators/file.validator");
const industryRoute = express_1.default.Router();
industryRoute.post("/add-industry", auth_1.verifyToken, upload_1.industryImage.fields([{ name: "image", maxCount: 1 }]), file_validator_1.validateFile, industry_validator_1.validateIndustry, (0, checkPermission_1.checkPermission)("Industry", "isAdd"), industry_1.addIndustry);
industryRoute.patch("/industry", auth_1.verifyToken, upload_1.industryImage.fields([{ name: "image", maxCount: 1 }]), file_validator_1.validateFile, industry_validator_1.validateIndustry, (0, checkPermission_1.checkPermission)("Industry", "isEdit"), industry_1.updateIndustry);
industryRoute.get("/industries", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("Industry", "isView"), industry_1.getIndustries);
industryRoute.delete("/industry/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("Industry", "isDelete"), industry_1.deleteIndustry);
industryRoute.get("/industry/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("Industry", "isView"), industry_1.getIndustryById);
exports.default = industryRoute;
