"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const audioPlayback_1 = require("../audio-playback/controllers/audioPlayback");
const audioPlayback_validator_1 = require("../validators/audioPlayback.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const audioPlaybackRoute = express_1.default.Router();
audioPlaybackRoute.post("/add-audio-Playback", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("audioPlayback", "isAdd"), audioPlayback_validator_1.validateAudioPlayback, audioPlayback_1.addAudioPlayback);
audioPlaybackRoute.patch("/audio-Playback", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("audioPlayback", "isEdit"), audioPlayback_validator_1.validateAudioPlayback, audioPlayback_1.updateAudioPlayback);
audioPlaybackRoute.get("/audio-Playbackes", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("audioPlayback", "isView"), audioPlayback_1.getAudioPlaybackes);
audioPlaybackRoute.delete("/audio-Playback/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("audioPlayback", "isDelete"), audioPlayback_1.deleteAudioPlayback);
audioPlaybackRoute.get("/audio-Playback/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("audioPlayback", "isView"), audioPlayback_1.getAudioPlaybackById);
exports.default = audioPlaybackRoute;
