"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addLanguage = addLanguage;
exports.updateLanguage = updateLanguage;
exports.getLanguages = getLanguages;
exports.deletelanguage = deletelanguage;
exports.getLanguageById = getLanguageById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const languageSetup_entity_1 = __importDefault(require("../entities/languageSetup.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//=========================== ADD A LANGUAGE ===========//
function addLanguage(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { newLanguage, status } = req.body;
        if (!newLanguage) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingUser = yield languageSetup_entity_1.default.findOne({
                newLanguage,
                isDeleted: false,
            });
            if (existingUser) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.language.languageExits);
            }
            else {
                const savedLanguageData = yield languageSetup_entity_1.default.create({
                    newLanguage,
                    status,
                });
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.language.success, savedLanguageData);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add language : ${error}`);
            console.log("Getting error while add language : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//=========================== UPDATE A LANGUAGE ===========//
function updateLanguage(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { newLanguage, status, _id } = req.body;
        try {
            const updatedLanguage = yield languageSetup_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { newLanguage, status }, { new: true });
            if (!updatedLanguage) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.language.languageNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.language.languageUpdated, updatedLanguage);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  update language : ${error}`);
            console.log("Getting error while  update language : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//=========================== GET ALL LANGUAGE ===========//
function getLanguages(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take } = query;
            const searchQuery = search
                ? { newLanguage: new RegExp(search, "i") }
                : {};
            let filters = { isDeleted: false };
            const options = {
                searchQuery,
                filter: filters,
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(languageSetup_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: data || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Error while fetching languages: ${error}`);
            console.log("Error while fetching languages: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//=========================== DELETE A LANGUAGE ===========//
function deletelanguage(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield languageSetup_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(id), isDeleted: false }, { isDeleted: true });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.language.languageDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  delete language : ${error}`);
            console.log("Getting error while  delete language : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//=========================== GET LANGUAGE BY ID ===========//
function getLanguageById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const language = yield languageSetup_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!language) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.language.languageNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, language);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  get language by id : ${error}`);
            console.error("Getting error while  get language by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
