"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importDefault(require("mongoose"));
const groupSchema = new mongoose_1.default.Schema({
    groupName: {
        type: String,
        required: true,
    },
    ageGroup: {
        minAge: {
            type: Number,
            required: true,
        },
        maxAge: {
            type: Number,
            required: true,
        },
    },
    subscriptionPlan: [
        {
            type: mongoose_1.default.Schema.Types.ObjectId,
            ref: "subscription",
        },
    ],
    transcribeUsageRange: {
        minUsage: {
            type: Number,
            required: true,
        },
        maxUsage: {
            type: Number,
            required: true,
        },
    },
    users: [
        {
            type: mongoose_1.default.Schema.Types.ObjectId,
            ref: "users",
        },
    ],
    status: {
        type: Boolean,
        required: true,
    },
    isDeleted: {
        type: Boolean,
        default: false,
    },
}, {
    timestamps: true,
});
exports.default = mongoose_1.default.model("group", groupSchema);
