"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addAudioPlayback = addAudioPlayback;
exports.updateAudioPlayback = updateAudioPlayback;
exports.getAudioPlaybackes = getAudioPlaybackes;
exports.deleteAudioPlayback = deleteAudioPlayback;
exports.getAudioPlaybackById = getAudioPlaybackById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const audioPlayback_entity_1 = __importDefault(require("../entities/audioPlayback.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//========================= Add Audio Playback ======================/
function addAudioPlayback(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { newAudioPlayback, status } = req.body;
        if (!newAudioPlayback) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingAudioPlayback = yield audioPlayback_entity_1.default.findOne({
                newAudioPlayback,
                isDeleted: false,
            });
            if (existingAudioPlayback) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.audioPlayback.audioPlaybackExits);
            }
            else {
                const savedAudioPlayback = yield audioPlayback_entity_1.default.create({
                    newAudioPlayback,
                    status,
                });
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.audioPlayback.success, savedAudioPlayback);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add audio playback : ${error}`);
            console.log("Getting error while add audio playback : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//========================= Update Audio Playback ===================//
function updateAudioPlayback(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { newAudioPlayback, status, _id } = req.body;
        try {
            const updatedAudioPlayback = yield audioPlayback_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { newAudioPlayback, status }, { new: true });
            if (!updatedAudioPlayback) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.audioPlayback.audioPlaybackNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.audioPlayback.audioPlaybackUpdated, updatedAudioPlayback);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while update audio playback : ${error}`);
            console.log("Getting error while update audio playback : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//========================= Get All Audio Playback ================//
function getAudioPlaybackes(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const audioPlaybackes = yield audioPlayback_entity_1.default.find({
                isDeleted: false,
            });
            if (!audioPlaybackes.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, audioPlaybackes);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get audio playbackes : ${error}`);
            console.log("Getting error while get audio playbackes : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//========================= Delete A Audio Playback =================//
function deleteAudioPlayback(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield audioPlayback_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(id), isDeleted: false }, { isDeleted: true });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.audioPlayback.audioPlaybackDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while delete audio playback : ${error}`);
            console.log("Getting error while delete audio playback : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//========================= Get Audio Playback By Id =================//
function getAudioPlaybackById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        try {
            const audioPlayback = yield audioPlayback_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!audioPlayback) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, (_a = api_response_1.messages.audioPlayback) === null || _a === void 0 ? void 0 : _a.audioPlaybackNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, audioPlayback);
        }
        catch (error) {
            console.error(`Getting error while  audio playback by id : ${error}`);
            logger_service_1.logger.error("Getting error while  audio playback by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
