"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addTranscriptionCategory = addTranscriptionCategory;
exports.updateTranscriptionCategory = updateTranscriptionCategory;
exports.getTranscriptionCategoryes = getTranscriptionCategoryes;
exports.deleteTranscriptionCategory = deleteTranscriptionCategory;
exports.getTranscriptionCategoryById = getTranscriptionCategoryById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const transcriptionCategory_entity_1 = __importDefault(require("../../transcription-category/entities/transcriptionCategory.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//=========================== ADD A NEW TRANSCRIPTION CATEGORY =========/
function addTranscriptionCategory(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { newTranscriptionCategory, status } = req.body;
        if (!newTranscriptionCategory) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingTranscriptionCategory = yield transcriptionCategory_entity_1.default.findOne({
                newTranscriptionCategory,
                isDeleted: false,
            });
            if (existingTranscriptionCategory) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.transcriptionCategory.transcriptionCategoryExits);
            }
            else {
                const savedTranscriptionCategoryData = yield transcriptionCategory_entity_1.default.create({
                    newTranscriptionCategory,
                    status,
                });
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.transcriptionCategory.success, savedTranscriptionCategoryData);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add transcription category: ${error}`);
            console.log(`Getting error while add transcription category: ${error}`);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//=========================== UPDATE A EXISTING TRANSCRIPTION CATEGORY =========/
function updateTranscriptionCategory(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { newTranscriptionCategory, status, _id } = req.body;
        try {
            const updatedTranscriptionData = yield transcriptionCategory_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { newTranscriptionCategory, status }, { new: true });
            if (!updatedTranscriptionData) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.transcriptionCategory.transcriptionCategoryNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.transcriptionCategory.transcriptionCategoryUpdated, updatedTranscriptionData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while update transcription category: ${error}`);
            console.log(`Getting error while update transcription category: ${error}`);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//=========================== GET ALL TRANSCRIPTION CATEGORY =========/
function getTranscriptionCategoryes(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take } = query;
            let searchQuery = {};
            if (search) {
                searchQuery = {
                    $or: [{ newTranscriptionCategory: new RegExp(search, "i") }],
                };
            }
            let filters = { isDeleted: false };
            const options = {
                searchQuery,
                filter: filters,
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(transcriptionCategory_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: data || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get transcription categoryes: ${error}`);
            console.log("Getting error while get transcription categoryes: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//=========================== DELETE A TRANSCRIPTION CATEGORY =========/
function deleteTranscriptionCategory(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield transcriptionCategory_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(id), isDeleted: false }, { isDeleted: true });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.transcriptionCategory.transcriptionCategoryDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while delete transcription category: ${error}`);
            console.log("Getting error while delete transcription category: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//=========================== GET TRANSCRIPTION CATEGROY BY ID =========/
function getTranscriptionCategoryById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const transcriptionCategory = yield transcriptionCategory_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!transcriptionCategory) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.transcriptionCategory.transcriptionCategoryNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, transcriptionCategory);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get transcription category by id: ${error}`);
            console.error(`Getting error while get transcription category by id: ${error}`);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
