"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addTicketSubject = addTicketSubject;
exports.updateTicketSubject = updateTicketSubject;
exports.getTicketSubjects = getTicketSubjects;
exports.deleteTicketSubject = deleteTicketSubject;
exports.getTicketSubjectById = getTicketSubjectById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const ticketSubject_entity_1 = __importDefault(require("../entities/ticketSubject.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//===================== ADD A NEW TICKET SUBJECT ================//
function addTicketSubject(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { subjectName, status } = req.body;
        if (!subjectName) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingTicket = yield ticketSubject_entity_1.default.findOne({
                subjectName,
                isDeleted: false,
            });
            if (existingTicket) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.ticketSubject.ticketSubjectExits);
            }
            else {
                const savedTicketData = yield ticketSubject_entity_1.default.create({
                    subjectName,
                    status,
                });
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.ticketSubject.success, savedTicketData);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add TicketSubject : ${error}`);
            console.log("Getting error while add TicketSubject : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//===================== UPDATE A EXISTING TICKET SUBJECT ================/
function updateTicketSubject(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { subjectName, status, _id } = req.body;
        try {
            const updatedTicket = yield ticketSubject_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { subjectName, status }, { new: true });
            if (!updatedTicket) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.ticketSubject.ticketSubjectNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.ticketSubject.ticketSubjectUpdated, updatedTicket);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  update language : ${error}`);
            console.log("Getting error while  update language : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//===================== GET ALL TICKET SUBJECT ================//
function getTicketSubjects(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take } = query;
            const searchQuery = search ? { subjectName: new RegExp(search, "i") } : {};
            let filters = { isDeleted: false };
            const options = {
                searchQuery,
                filter: filters,
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(ticketSubject_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: data || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  get ticket : ${error}`);
            console.log("Getting error while  get ticket : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//===================== DELETE A TICKET SUBJECT ================//
function deleteTicketSubject(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield ticketSubject_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(id), isDeleted: false }, { isDeleted: true });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.ticketSubject.ticketSubjectDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  delete ticket : ${error}`);
            console.log("Getting error while  delete ticket :", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//===================== GET TICKET SUBJECT BY ID  ================//
function getTicketSubjectById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const ticket = yield ticketSubject_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!ticket) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.ticketSubject.ticketSubjectNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, ticket);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  get ticket subject by id : ${error}`);
            console.error("Getting error while  get ticket subject by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
