"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const checkPermission_1 = require("../middleware/checkPermission");
const yourRole_validator_1 = require("../validators/yourRole.validator");
const yourRole_1 = require("../user-options/controllers/yourRole");
const yourRoleRoutes = express_1.default.Router();
yourRoleRoutes.post("/add-your-role", auth_1.verifyToken, yourRole_validator_1.validateYourRole, (0, checkPermission_1.checkPermission)("Your Role", "isAdd"), yourRole_1.addYourRole);
yourRoleRoutes.patch("/your-role", auth_1.verifyToken, yourRole_validator_1.validateYourRole, (0, checkPermission_1.checkPermission)("Your Role", "isEdit"), yourRole_1.updateYourRole);
yourRoleRoutes.get("/your-roles", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("Your Role", "isView"), yourRole_1.getYourRoles);
yourRoleRoutes.delete("/your-role/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("Your Role", "isDelete"), yourRole_1.deleteYourRole);
yourRoleRoutes.get("/your-role/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("Your Role", "isView"), yourRole_1.getYourRoleById);
exports.default = yourRoleRoutes;
