"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const termsConditions_1 = require("../terms-conditions/components/termsConditions");
const termsConditions_validator_1 = require("../validators/termsConditions.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const termsConditionRoute = express_1.default.Router();
termsConditionRoute.get("/terms-condition", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("termsAndConditions", "isView"), termsConditions_1.getTermsCondition);
termsConditionRoute.patch("/terms-condition", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("termsAndConditions", "isEdit"), termsConditions_validator_1.validateTermsConditions, termsConditions_1.updateTermsCondition);
exports.default = termsConditionRoute;
