"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const outputFormat_1 = require("../output-format/controllers/outputFormat");
const outputFormat_validator_1 = require("../validators/outputFormat.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const outputFormatRoute = express_1.default.Router();
outputFormatRoute.post("/add-output-format", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("outputFormat", "isAdd"), outputFormat_validator_1.validateOutputFormat, outputFormat_1.addOutputFormat);
outputFormatRoute.patch("/output-format", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("outputFormat", "isEdit"), outputFormat_validator_1.validateOutputFormat, outputFormat_1.updateOutputFormat);
outputFormatRoute.get("/output-formats", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("outputFormat", "isView"), outputFormat_1.getOutputFormats);
outputFormatRoute.delete("/output-format/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("outputFormat", "isDelete"), outputFormat_1.deleteOutputFormat);
outputFormatRoute.get("/output-format/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("outputFormat", "isView"), outputFormat_1.getOutputFormatById);
exports.default = outputFormatRoute;
