"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const group_1 = require("../group/controllers/group");
const group_validate_1 = require("../validators/group.validate");
const checkPermission_1 = require("../middleware/checkPermission");
const groupRoute = express_1.default.Router();
groupRoute.post("/create-group", auth_1.verifyToken, group_validate_1.validateGroup, (0, checkPermission_1.checkPermission)("groupManagement", "isAdd"), group_1.createGroup);
groupRoute.get("/groups", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("groupManagement", "isView"), group_1.getGroups);
groupRoute.get("/all-groups", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("groupManagement", "isView"), group_1.getGroupsWithOutPagination);
groupRoute.patch("/group", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("groupManagement", "isEdit"), group_validate_1.validateGroup, group_1.updateGroup);
groupRoute.get("/group/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("groupManagement", "isView"), group_1.getGroupById);
groupRoute.delete("/group/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("groupManagement", "isDelete"), group_1.deleteGroup);
exports.default = groupRoute;
