"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRecordedFile = exports.thematicAnalytic = exports.deleteOutPutFiles = exports.getAllOutPutFile = exports.exportOutPutFile = exports.youTubeUpload = exports.getById = exports.deleteFiles = exports.get = exports.editInputFile = exports.add = void 0;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const input_file_entity_1 = require("../entities/input-file.entity");
const outPutFileSchema_1 = require("../entities/outPutFileSchema");
const get_video_duration_1 = require("get-video-duration");
const sdk_1 = require("@deepgram/sdk");
const fs = __importStar(require("fs"));
const mongoose_1 = __importDefault(require("mongoose"));
const path_1 = __importDefault(require("path"));
const openai_1 = __importDefault(require("openai"));
const thematicAnalysisSchema_1 = require("../entities/thematicAnalysisSchema");
const api_response_1 = require("../../api.response");
const utills_1 = require("../../service/utills");
const screenshot_service_1 = require("../../service/screenshot.service");
const multer_1 = require("../../helpers/multer");
const screenshotService = new screenshot_service_1.ScreenshotService();
const add = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w;
    try {
        const { model, transcriptionId, isRecorded, workspaceId } = req.body;
        if (!workspaceId) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.workspace.workspaceNotFound);
        }
        if (req.user.userType != utills_1.USER_TYPE.USER) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.insufficient_Permissions);
        }
        if (!req.files) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        if (req.files.length > 10) {
            for (let index = 0; index < req.files; index++) {
                const element = req.files[index];
                fs.unlink(element.path.replace(/\\/g, "/"), (err) => {
                    if (err) {
                        console.error(`Error removing file: ${err}`);
                        return;
                    }
                });
            }
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.maxFile);
        }
        if (req.files.length > 1) {
            let batchName = yield generateBatch((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id);
            let filesData = [];
            let totalAmount = 0;
            for (const file of req.files) {
                if (file.size > 209715200) {
                    return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Failed to upload file, Your file is larger than the 200MB size limit.");
                }
                const duration = (yield (0, get_video_duration_1.getVideoDurationInSeconds)(file.path)) / 60;
                const deepgramResponse = yield postDataToDeepgram(file.path.replace(/\\/g, "/"), model);
                // const fileName = file.path.replace("public/", process.env.FILE_URL);
                const fileName = file.path.replace(/^public[\\/]/, "");
                const thumbnailURL = yield takeScreenshot(file.path);
                if (deepgramResponse.StatusCode === api_response_1.StatusCode.Ok) {
                    const deepgramUsages = yield checkDeepgramUsages((_c = (_b = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _b === void 0 ? void 0 : _b.metadata) === null || _c === void 0 ? void 0 : _c.request_id);
                    const deepgramTranscript = (_h = (_g = (_f = (_e = (_d = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _d === void 0 ? void 0 : _d.results) === null || _e === void 0 ? void 0 : _e.channels[0]) === null || _f === void 0 ? void 0 : _f.alternatives[0]) === null || _g === void 0 ? void 0 : _g.transcript) !== null && _h !== void 0 ? _h : "";
                    // const summaryResponse = await openAIResponse(
                    //   deepgramTranscript,
                    //   "summary"
                    // );
                    // const keyThemesResponse = await openAIResponse(
                    //   deepgramTranscript,
                    //   "keyThemes"
                    // );
                    totalAmount += deepgramUsages.data;
                    filesData.push({
                        _id: new mongoose_1.default.Types.ObjectId(),
                        fileName: file.originalname,
                        duration: duration ? duration.toFixed(2) : 0,
                        model: model,
                        status: "Completed",
                        fileURL: fileName,
                        thumbnailURL,
                        deepgram: deepgramResponse.data,
                        // summary: summaryResponse.data.choices[0].message.content.trim(),
                        // keyThemes: keyThemesResponse.data.choices[0].message.content.trim(),
                    });
                }
                else {
                    return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Failed to upload file.");
                }
            }
            const createInputFile = yield input_file_entity_1.inputFile.create({
                file: filesData,
                batchName: batchName,
                userId: new mongoose_1.default.Types.ObjectId((_j = req === null || req === void 0 ? void 0 : req.user) === null || _j === void 0 ? void 0 : _j._id), // THIS CAN BE REMOVED
                amount: Number(totalAmount.toFixed(3)),
                // NEW ADDITIONS IN CONTENT PRO
                isRecorded,
                workspaceId,
                owner: new mongoose_1.default.Types.ObjectId((_k = req === null || req === void 0 ? void 0 : req.user) === null || _k === void 0 ? void 0 : _k._id), // OWNER OF FILE
                users: [new mongoose_1.default.Types.ObjectId((_l = req === null || req === void 0 ? void 0 : req.user) === null || _l === void 0 ? void 0 : _l._id)], // USERS ARRAY
            });
            const createInputFileResponse = createInputFile.toObject();
            createInputFileResponse.transcriptionId = transcriptionId;
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, "File Upload successfully", createInputFileResponse);
        }
        else {
            if (req.files[0].size > 209715200) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Failed to upload file, Your file is larger than the 200MB size limit.");
            }
            const duration = (yield (0, get_video_duration_1.getVideoDurationInSeconds)(req.files[0].path)) / 60;
            const deepgramResponse = yield postDataToDeepgram(req.files[0].path.replace(/\\/g, "/"), model);
            // const fileName = req.files[0].path.replace(
            //   "public/",
            //   process.env.FILE_URL
            // );
            const fileName = req.files[0].path.replace(/^public[\\/]/, "");
            const thumbnailURL = yield takeScreenshot(req.files[0].path);
            if (deepgramResponse.StatusCode === api_response_1.StatusCode.Ok) {
                const deepgramUsages = yield checkDeepgramUsages((_o = (_m = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _m === void 0 ? void 0 : _m.metadata) === null || _o === void 0 ? void 0 : _o.request_id);
                const deepgramTranscript = (_t = (_s = (_r = (_q = (_p = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _p === void 0 ? void 0 : _p.results) === null || _q === void 0 ? void 0 : _q.channels[0]) === null || _r === void 0 ? void 0 : _r.alternatives[0]) === null || _s === void 0 ? void 0 : _s.transcript) !== null && _t !== void 0 ? _t : "";
                // const summaryResponse = await openAIResponse(
                //   deepgramTranscript,
                //   "summary"
                // );
                // const keyThemesResponse = await openAIResponse(
                //   deepgramTranscript,
                //   "keyThemes"
                // );
                const createInputFile = yield input_file_entity_1.inputFile.create({
                    file: {
                        _id: new mongoose_1.default.Types.ObjectId(),
                        fileName: req.files[0].originalname,
                        duration: duration ? duration.toFixed(2) : 0,
                        model: model,
                        status: "Completed",
                        fileURL: fileName,
                        thumbnailURL,
                        deepgram: deepgramResponse.data,
                        // summary: summaryResponse.data.choices[0].message.content.trim(),
                        // keyThemes: keyThemesResponse.data.choices[0].message.content.trim(),
                    },
                    amount: Number(deepgramUsages.data.toFixed(0, 3)),
                    userId: new mongoose_1.default.Types.ObjectId((_u = req === null || req === void 0 ? void 0 : req.user) === null || _u === void 0 ? void 0 : _u._id), //THIS CAN BE REMOVED
                    // NEW ADDITIONS IN CONTENT PRO
                    isRecorded,
                    workspaceId,
                    owner: new mongoose_1.default.Types.ObjectId((_v = req === null || req === void 0 ? void 0 : req.user) === null || _v === void 0 ? void 0 : _v._id), // OWNER OF FILE
                    users: [new mongoose_1.default.Types.ObjectId((_w = req === null || req === void 0 ? void 0 : req.user) === null || _w === void 0 ? void 0 : _w._id)], // USERS ARRAY
                });
                const createInputFileResponse = createInputFile.toObject();
                createInputFileResponse.transcriptionId = transcriptionId;
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, "File Upload successfully", createInputFileResponse);
            }
            else {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Failed to upload file.");
            }
        }
    }
    catch (error) {
        console.log("Getting error while upload file and transcribe the file", error);
        logger_service_1.logger.error(`Getting error while upload file and transcribe the file : ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.add = add;
//============================ UPDATE INPUT FILES========================//
const editInputFile = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { batchName, _id } = req.body;
        let isInputFile = yield input_file_entity_1.inputFile.findById(_id);
        if (!isInputFile) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.inputFile.invalidInputFile);
        }
        let updatedInputFile = yield input_file_entity_1.inputFile.findByIdAndUpdate(_id, { batchName: batchName }, { new: true });
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.inputFile.updateSuccess, updatedInputFile);
    }
    catch (error) {
        console.log("Getting error while edit input file ::", error);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.editInputFile = editInputFile;
// =========================== GET INPUT FILE =========================== /
// export const get = async (req: any, res: Response) => {
//   try {
//     const { take, page, search, isBatch, workspaceId } = req.query;
//     delete req.query.take;
//     delete req.query.page;
//     delete req.query.search;
//     delete req.query.isBatch;
//     delete req.query.workspaceId;
//     if (!workspaceId) {
//       return sendMessageResponse(
//         req,
//         res,
//         StatusCode.BadRequest,
//         messages.workspace.workspaceNotFound
//       );
//     }
//     if (req.user.userType != "USER") {
//       return sendMessageResponse(
//         req,
//         res,
//         StatusCode.BadRequest,
//         messages.insufficient_Permissions
//       );
//     }
//     // PAGINATION
//     const takePerPage = Number(take) || 10;
//     let pageCount = Number(page) || 1;
//     if (pageCount == 0) {
//       pageCount = 1;
//     }
//     const skip = (pageCount - 1) * takePerPage;
//     // Create QUERY
//     let query: any = {};
//     // GLOBAL FILTER
//     if (search) {
//       query = {
//         ...query,
//         $and: [
//           {
//             $or: [
//               { "file.fileName": { $regex: search, $options: "i" } },
//               { batchName: { $regex: search, $options: "i" } },
//             ],
//           },
//         ],
//       };
//     }
//     if (isBatch === "true") {
//       query.batchName = { $ne: null };
//     } else if (isBatch === "false") {
//       query.batchName = { $eq: null };
//     }
//     const fileInputResponse = await inputFile.aggregate([
//       {
//         $match: query,
//       },
//       {
//         $sort: {
//           createdAt: -1,
//         },
//       },
//       // {
//       //   $match: {
//       //     userId: new mongoose.Types.ObjectId(req?.user?._id),
//       //   },
//       // },
//       {
//         $match: {
//           workspaceId: new mongoose.Types.ObjectId(workspaceId),
//         },
//       },
//       {
//         $match: {
//           // Check if the userId exists in the 'users' array
//           users: {
//             $in: [new mongoose.Types.ObjectId(req?.user?._id)],
//           },
//         },
//       },
//       {
//         $facet: {
//           metadata: [{ $count: "totalCount" }],
//           data: [{ $skip: skip }, { $limit: takePerPage }],
//         },
//       },
//     ]);
//     const metadata = fileInputResponse[0].metadata[0];
//     const totalCount = metadata ? metadata.totalCount : 0;
//     // PAGINATION
//     const totalPages = Math.ceil(totalCount / takePerPage);
//     const nextPage = pageCount < totalPages ? pageCount + 1 : null;
//     const prevPage = pageCount > 1 ? pageCount - 1 : null;
//     const responseData = {
//       docs: fileInputResponse[0]?.data || [],
//       count: totalCount,
//       pages: totalPages,
//       currentPage: Number(page),
//       nextPage,
//       prevPage,
//     };
//     return sendDataResponse(
//       req,
//       res,
//       StatusCode.Ok,
//       "Files data fetch successfully.",
//       responseData
//     );
//   } catch (error) {
//     console.log("Getting error while get the input file", error);
//     logger.error(`Getting error while get the input file : ${error}`);
//     return sendMessageResponse(
//       req,
//       res,
//       StatusCode.InternalServerError,
//       messages.internalServerError
//     );
//   }
// };
const get = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    try {
        const { take, page, search, isBatch, workspaceId, startDate, endDate } = req.query;
        delete req.query.take;
        delete req.query.page;
        delete req.query.search;
        delete req.query.isBatch;
        delete req.query.workspaceId;
        delete req.query.startDate;
        delete req.query.endDate;
        if (!workspaceId) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.workspace.workspaceNotFound);
        }
        if (req.user.userType != "USER") {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.insufficient_Permissions);
        }
        // PAGINATION
        const takePerPage = Number(take) || 10;
        let pageCount = Number(page) || 1;
        if (pageCount == 0) {
            pageCount = 1;
        }
        const skip = (pageCount - 1) * takePerPage;
        // Create QUERY
        let query = {};
        // GLOBAL FILTER
        if (search) {
            query = Object.assign(Object.assign({}, query), { $and: [
                    {
                        $or: [
                            { "file.fileName": { $regex: search, $options: "i" } },
                            { batchName: { $regex: search, $options: "i" } },
                        ],
                    },
                ] });
        }
        // Filter by isBatch
        if (isBatch === "true") {
            query.batchName = { $ne: null };
        }
        else if (isBatch === "false") {
            query.batchName = { $eq: null };
        }
        // Filter by createdAt range
        if (startDate || endDate) {
            query.createdAt = {};
            if (startDate) {
                query.createdAt.$gte = new Date(startDate);
            }
            if (endDate) {
                query.createdAt.$lte = new Date(endDate);
            }
        }
        const fileInputResponse = yield input_file_entity_1.inputFile.aggregate([
            {
                $match: query,
            },
            {
                $sort: {
                    createdAt: -1,
                },
            },
            {
                $match: {
                    workspaceId: new mongoose_1.default.Types.ObjectId(workspaceId),
                },
            },
            {
                $match: {
                    users: {
                        $in: [new mongoose_1.default.Types.ObjectId((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id)],
                    },
                },
            },
            {
                $facet: {
                    metadata: [{ $count: "totalCount" }],
                    data: [{ $skip: skip }, { $limit: takePerPage }],
                },
            },
        ]);
        const metadata = fileInputResponse[0].metadata[0];
        const totalCount = metadata ? metadata.totalCount : 0;
        // PAGINATION
        const totalPages = Math.ceil(totalCount / takePerPage);
        const nextPage = pageCount < totalPages ? pageCount + 1 : null;
        const prevPage = pageCount > 1 ? pageCount - 1 : null;
        const responseData = {
            docs: ((_b = fileInputResponse[0]) === null || _b === void 0 ? void 0 : _b.data) || [],
            count: totalCount,
            pages: totalPages,
            currentPage: Number(page),
            nextPage,
            prevPage,
        };
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, "Files data fetched successfully.", responseData);
    }
    catch (error) {
        console.log("Getting error while getting the input file", error);
        logger_service_1.logger.error(`Getting error while getting the input file : ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.get = get;
// =========================== GENERATE BATCH =========================== /
function generateBatch(userId) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const count = yield input_file_entity_1.inputFile.countDocuments({
                // userId: userId,
                owner: userId,
                batchName: { $ne: null },
            });
            return `Batch-${count}`;
        }
        catch (error) {
            console.log("Getting error while generate batch", error);
            logger_service_1.logger.error(`Getting error while add-user : ${error}`);
            throw new Error("Getting error while generate batch");
        }
    });
}
// =========================== POST DATA TO DEEPGRAM TRANSCRIBE =========================== /
function postDataToDeepgram(url, model) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const deepgram = (0, sdk_1.createClient)(process.env.DEEPGRAM_KEY);
            const transcribeOptions = {
                model: "nova-2",
                smart_format: true,
                // summarize: "v2",
                // topics: true, //model.includes("TopicDetection") ? true : false,
                // diarize: model.includes("Diarization") ? true : false,
                // paragraphs: model.includes("Paragraphs") ? true : false,
            };
            const { result, error } = yield deepgram.listen.prerecorded.transcribeFile(fs.createReadStream(url), transcribeOptions);
            if (error) {
                console.log("Error in Post Data to Deepgram 1:: ", error);
                return { StatusCode: api_response_1.StatusCode.BadRequest };
            }
            return { StatusCode: api_response_1.StatusCode.Ok, data: result };
        }
        catch (error) {
            console.log("Error in Post Data to Deepgram 2:: ", error);
            return { StatusCode: api_response_1.StatusCode.BadRequest };
        }
    });
}
// =========================== DELETE INPUT FILE & BATCH =========================== /
// export const deleteFiles = async (req: any, res: Response) => {
//   try {
//     if (
//       !Array.isArray(req.body.ids) ||
//       req.body.ids.length === 0 ||
//       req.body.ids.every((id: any) => id === null)
//     ) {
//       return sendMessageResponse(
//         req,
//         res,
//         StatusCode.BadRequest,
//         "Please select to delete input files."
//       );
//     }
//     const _id = req.body.ids.map(
//       (id: string) => new mongoose.Types.ObjectId(id)
//     );
//     const findID = await inputFile.findById({ _id });
//     if (!findID) {
//       return sendMessageResponse(req, res, StatusCode.BadRequest, "Invalid Id");
//     }
//     await inputFile.deleteMany({ _id: { $in: _id } });
//     return sendMessageResponse(
//       req,
//       res,
//       StatusCode.Ok,
//       "Files deleted successfully."
//     );
//   } catch (error) {
//     console.log("Getting error while delete the input file", error);
//     logger.error(`Getting error while delete the input file : ${error}`);
//     return sendMessageResponse(
//       req,
//       res,
//       StatusCode.InternalServerError,
//       messages.internalServerError
//     );
//   }
// };
const deleteFiles = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        if (!Array.isArray(req.body.ids) ||
            req.body.ids.length === 0 ||
            req.body.ids.every((id) => id === null)) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Please select files to delete.");
        }
        const _fileIds = req.body.ids.map((id) => new mongoose_1.default.Types.ObjectId(id));
        // Find all documents containing the files with the given IDs
        const documents = yield input_file_entity_1.inputFile.find({ "file._id": { $in: _fileIds } });
        if (!documents || documents.length === 0) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "No files found.");
        }
        for (const doc of documents) {
            const fileArray = doc.file;
            // Filter out the files to be deleted
            const updatedFileArray = fileArray.filter((file) => !_fileIds.some((fileId) => fileId.equals(file._id)));
            // If no files are left after deletion, delete the entire document
            if (updatedFileArray.length === 0) {
                yield input_file_entity_1.inputFile.deleteOne({ _id: doc._id });
            }
            else {
                // Update the document with the remaining files
                yield input_file_entity_1.inputFile.updateOne({ _id: doc._id }, { $set: { file: updatedFileArray } });
            }
        }
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, "Selected files deleted successfully.");
    }
    catch (error) {
        console.log("Error while deleting the files:", error);
        logger_service_1.logger.error(`Error while deleting the files: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.deleteFiles = deleteFiles;
// =========================== INPUT FILE GET BY ID =========================== /
const getById = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const _id = req.params.id;
        const findInputFile = yield input_file_entity_1.inputFile.aggregate([
            {
                $match: {
                    _id: new mongoose_1.default.Types.ObjectId(_id),
                },
            },
            {
                $lookup: {
                    from: "thematic-analyses",
                    localField: "_id",
                    foreignField: "mediaId",
                    as: "thematicAnalyses",
                },
            },
            {
                $project: {
                    _id: 1,
                    file: 1,
                    batchName: 1,
                    createdAt: 1,
                    userId: 1,
                    owner: 1,
                    isRecorded: 1,
                    workspaceId: 1,
                    // thematicAnalyses: "$thematicAnalyses",
                    thematicAnalyses: {
                        $slice: ["$thematicAnalyses", -1, 1],
                    },
                },
            },
        ]);
        if (!findInputFile) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, "Record not found.");
        }
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, "Files data fetch successfully.", findInputFile[0]);
    }
    catch (error) {
        console.log("Getting error while fine result by id the input file", error);
        logger_service_1.logger.error(`Getting error while fine result by id the input file : ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.getById = getById;
const processYouTubeURL = (ytURL) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c;
    let totalAmount = 0;
    let model = [];
    // Usage with your youtube-dl code
    // const title = await youtubedl(ytURL, {
    //   getTitle: true,
    //   noWarnings: true,
    //   noCheckCertificates: true,
    //   preferFreeFormats: true,
    //   youtubeSkipDashManifest: true,
    // });
    const title = "Test";
    const fileName = (0, multer_1.sanitizeFileName)(title);
    const tempName = Date.now();
    const outputPath = path_1.default.join(__dirname, "../../../public/input-file", `${tempName}.mp4`);
    // // Download video and convert it to webm
    // await youtubedl(ytURL, {
    //   output: outputPath,
    //   // extractAudio: true,
    //   // video: "webm",
    // });
    yield (0, common_service_1.downloadVideo)(ytURL, tempName);
    const duration = (yield (0, get_video_duration_1.getVideoDurationInSeconds)(outputPath.replace(/\\/g, "/"))) / 60;
    const deepgramResponse = yield postDataToDeepgram(outputPath.replace(/\\/g, "/"), model);
    // const fileURL = outputPath.replace(
    //   "/var/www/html/contentpro-backend/public/",
    //   process.env.FILE_URL ?? ""
    // );
    // const relativePath = outputPath.match(/public.*/)?.[0] || "";
    const relativePath = ((_a = outputPath.match(/public\/(.*)/)) === null || _a === void 0 ? void 0 : _a[1]) || "";
    const thumbnailURL = yield takeScreenshot("public/" + relativePath);
    if (deepgramResponse.StatusCode === api_response_1.StatusCode.Ok) {
        const deepgramUsages = yield checkDeepgramUsages((_c = (_b = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _b === void 0 ? void 0 : _b.metadata) === null || _c === void 0 ? void 0 : _c.request_id);
        // const deepgramTranscript =
        //   deepgramResponse?.data?.results?.channels[0]?.alternatives[0]
        //     ?.transcript ?? "";
        // const summaryResponse = await openAIResponse(deepgramTranscript, "summary");
        // const keyThemesResponse = await openAIResponse(
        //   deepgramTranscript,
        //   "keyThemes"
        // );
        totalAmount += deepgramUsages.data;
        // REMOVE FILE ONCE ITS DONE TRANSCRIBING
        fs.unlink(outputPath.replace(/\\/g, "/"), (err) => {
            if (err) {
                console.error(`Error removing file: ${err}`);
                return;
            }
        });
        return {
            _id: new mongoose_1.default.Types.ObjectId(),
            fileName,
            duration: duration.toFixed(2),
            model,
            status: "Completed",
            // fileURL: relativePath,
            thumbnailURL,
            deepgram: deepgramResponse.data,
            // summary: summaryResponse.data.choices[0].message.content.trim(),
            // keyThemes: keyThemesResponse.data.choices[0].message.content.trim(),
            totalAmount,
            uploadType: input_file_entity_1.UPLOAD_TYPE.YOUTUBE,
            ytURL: ytURL,
        };
    }
    else {
        throw new Error("Failed to upload file.");
    }
});
const youTubeUpload = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d;
    try {
        const { youTubeURL, transcriptionId, workspaceId } = req.body;
        if (!workspaceId) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.workspace.workspaceNotFound);
        }
        const isBatch = (youTubeURL === null || youTubeURL === void 0 ? void 0 : youTubeURL.length) > 1;
        const batchName = isBatch ? yield generateBatch((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id) : null;
        let totalAmount = 0;
        // Use Promise.all to run all video processing concurrently
        const promArr = youTubeURL === null || youTubeURL === void 0 ? void 0 : youTubeURL.map((ytURL) => __awaiter(void 0, void 0, void 0, function* () {
            try {
                return yield processYouTubeURL(ytURL);
            }
            catch (err) {
                console.error("Error processing video:", err);
                throw err;
            }
        }));
        const filesData = yield Promise.all(promArr);
        filesData.forEach((item) => {
            totalAmount += item.totalAmount;
        });
        const createInputFile = yield input_file_entity_1.inputFile.create({
            file: isBatch ? filesData : filesData[0],
            batchName: isBatch ? `yt-${batchName}` : null,
            userId: new mongoose_1.default.Types.ObjectId((_b = req === null || req === void 0 ? void 0 : req.user) === null || _b === void 0 ? void 0 : _b._id),
            amount: Number(totalAmount.toFixed(3)),
            // NEW IMPLEMENTATION IN CONTENT PRO
            isRecorded: false,
            workspaceId,
            owner: new mongoose_1.default.Types.ObjectId((_c = req === null || req === void 0 ? void 0 : req.user) === null || _c === void 0 ? void 0 : _c._id), // OWNER OF FILE
            users: [new mongoose_1.default.Types.ObjectId((_d = req === null || req === void 0 ? void 0 : req.user) === null || _d === void 0 ? void 0 : _d._id)], // USERS ARRAY
        });
        const createInputFileResponse = createInputFile.toObject();
        createInputFileResponse.transcriptionId = transcriptionId;
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, "File Upload successfully", createInputFileResponse);
    }
    catch (error) {
        console.log("Getting Error while uploading YouTube link:", error);
        logger_service_1.logger.error(`Getting Error while uploading YouTube link: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.youTubeUpload = youTubeUpload;
// =========================== OUT PUT FILE =========================== /
const exportOutPutFile = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    try {
        const { _id, exportType } = req.body;
        if (!_id || !exportType) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Id & export type is required");
        }
        const findInputFile = yield input_file_entity_1.inputFile.findById({
            _id,
        });
        if (!findInputFile) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Please check your selected Id");
        }
        const saveOutPutFile = yield outPutFileSchema_1.outPutFile.create({
            file: findInputFile.file,
            batchName: findInputFile.batchName,
            userId: new mongoose_1.default.Types.ObjectId((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id),
            exportType: exportType,
            inputFileId: new mongoose_1.default.Types.ObjectId(findInputFile === null || findInputFile === void 0 ? void 0 : findInputFile._id),
        });
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, "Out-Put file store successfully", saveOutPutFile);
    }
    catch (error) {
        console.log("Getting Error while store the out put file:", error);
        logger_service_1.logger.error(`Getting Error while store the out put file: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.exportOutPutFile = exportOutPutFile;
// =========================== GET ALL OUT-PUT FILE =========================== /
const getAllOutPutFile = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c;
    try {
        const { take, page, search, isBatch } = req.query;
        delete req.query.take;
        delete req.query.page;
        delete req.query.search;
        delete req.query.isBatch;
        if (req.user.userType != "USER") {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.insufficient_Permissions);
        }
        // PAGINATION
        const takePerPage = Number(take) || 10;
        let pageCount = Number(page) || 1;
        if (pageCount == 0) {
            pageCount = 1;
        }
        const skip = (pageCount - 1) * takePerPage;
        // Create QUERY
        let query = {};
        // GLOBAL FILTER
        if (search) {
            query = Object.assign(Object.assign({}, query), { $and: [
                    {
                        $or: [
                            { "file.fileName": { $regex: search, $options: "i" } },
                            { batchName: { $regex: search, $options: "i" } },
                        ],
                    },
                ], userId: new mongoose_1.default.Types.ObjectId((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id) });
        }
        if (isBatch === "true") {
            query.batchName = { $ne: null };
        }
        else if (isBatch === "false") {
            query.batchName = { $eq: null };
        }
        const fileInputResponse = yield outPutFileSchema_1.outPutFile.aggregate([
            {
                $match: query,
            },
            {
                $sort: {
                    createdAt: -1,
                },
            },
            {
                $match: {
                    userId: new mongoose_1.default.Types.ObjectId((_b = req === null || req === void 0 ? void 0 : req.user) === null || _b === void 0 ? void 0 : _b._id),
                },
            },
            {
                $facet: {
                    metadata: [{ $count: "totalCount" }],
                    data: [{ $skip: skip }, { $limit: takePerPage }],
                },
            },
        ]);
        const metadata = fileInputResponse[0].metadata[0];
        const totalCount = metadata ? metadata.totalCount : 0;
        // PAGINATION
        const totalPages = Math.ceil(totalCount / takePerPage);
        const nextPage = pageCount < totalPages ? pageCount + 1 : null;
        const prevPage = pageCount > 1 ? pageCount - 1 : null;
        const responseData = {
            docs: ((_c = fileInputResponse[0]) === null || _c === void 0 ? void 0 : _c.data) || [],
            count: totalCount,
            pages: totalPages,
            currentPage: Number(page),
            nextPage,
            prevPage,
        };
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, "Out-Put Files data fetch successfully.", responseData);
    }
    catch (error) {
        console.log("Getting Error while get the all out put file:", error);
        logger_service_1.logger.error(`Getting Error while get the all out put file: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.getAllOutPutFile = getAllOutPutFile;
// =========================== DELETE OUTPUT FILE & BATCH =========================== /
const deleteOutPutFiles = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        if (!Array.isArray(req.body.ids) ||
            req.body.ids.length === 0 ||
            req.body.ids.every((id) => id === null)) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Please select to delete input files.");
        }
        const _id = req.body.ids.map((id) => new mongoose_1.default.Types.ObjectId(id));
        yield outPutFileSchema_1.outPutFile.deleteMany({ _id: { $in: _id } });
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, "Output files deleted successfully.");
    }
    catch (error) {
        console.log("Getting error while delete the output file", error);
        logger_service_1.logger.error(`Getting error while delete the output file : ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.deleteOutPutFiles = deleteOutPutFiles;
// =========================== THEMATIC ANALYTIC =========================== /
const thematicAnalytic = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    try {
        const openai = new openai_1.default({
            apiKey: process.env.THEMATIC_ANALYTIC_KEY,
        });
        const { _id, content } = req.body;
        if (!_id) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Id is required.");
        }
        for (let index = 0; index < content.length; index++) {
            const element = content[index];
            let len = element.length;
            if (len > 128000) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Your request entity too large.");
            }
        }
        if (!content) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Content is required.");
        }
        /* const combinedText = content.join("\n\n---\n\n");
        const promptString = `${prompt}:\n\n${combinedText}`;
    
        const response = await openai.chat.completions.create({
          model: "gpt-4o-mini",
          messages: [
            {
              role: "system",
              content: "You are a helpful assistant for thematic analysis.",
            },
            { role: "user", content: promptString },
          ],
          max_tokens: 500,
          temperature: 0.3,
        }); */
        const response = yield openai.chat.completions.create({
            model: "chatgpt-4o-latest",
            messages: [...content],
            max_tokens: 16383,
            temperature: 0.3,
            top_p: 1.0,
            frequency_penalty: 0.0,
            presence_penalty: 0.0,
        });
        if (response.choices[0].message.content.trim()) {
            yield thematicAnalysisSchema_1.thematicAnalysis.create({
                mediaId: new mongoose_1.default.Types.ObjectId(_id),
                userId: new mongoose_1.default.Types.ObjectId((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id),
                response: response.choices[0].message.content.trim(),
            });
        }
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, response.choices[0].message.content.trim());
    }
    catch (error) {
        console.log("Getting error while thematic analytic processing", error);
        logger_service_1.logger.error(`Getting error while thematic analytic processing: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.thematicAnalytic = thematicAnalytic;
// async function checkDeepgramUsages(requestId: string) {
//   try {
//     const url = `https://api.deepgram.com/v1/projects/${process.env.DEEPGRAM_PROJECT_ID}/requests/${requestId}`;
//     const options = {
//       method: "GET",
//       headers: {
//         accept: "application/json",
//         Authorization: `Token ${process.env.DEEPGRAM_KEY}`,
//       },
//     };
//     const response = await fetch(url, options);
//     const json = await response.json();
//     const usd = json.response.details.usd;
//     return { StatusCode: StatusCode.Ok, data: usd };
//   } catch (error) {
//     console.log("Getting error while checking deepgram usage", error);
//     logger.error(`Getting error while checking deepgram usage: ${error}`);
//     throw new Error("Getting error while checking deepgram usage");
//   }
// }
function checkDeepgramUsages(requestId_1) {
    return __awaiter(this, arguments, void 0, function* (requestId, retries = 2) {
        var _a, _b, _c;
        try {
            const url = `https://api.deepgram.com/v1/projects/${process.env.DEEPGRAM_PROJECT_ID}/requests/${requestId}`;
            const options = {
                method: "GET",
                headers: {
                    accept: "application/json",
                    Authorization: `Token ${process.env.DEEPGRAM_KEY}`,
                },
            };
            const response = yield fetch(url, options);
            const json = yield response.json();
            if ((json === null || json === void 0 ? void 0 : json.response) &&
                ((_a = json === null || json === void 0 ? void 0 : json.response) === null || _a === void 0 ? void 0 : _a.details) &&
                ((_c = (_b = json === null || json === void 0 ? void 0 : json.response) === null || _b === void 0 ? void 0 : _b.details) === null || _c === void 0 ? void 0 : _c.usd)) {
                const usd = json.response.details.usd;
                return { StatusCode: api_response_1.StatusCode.Ok, data: usd };
            }
            // Retry logic if details are undefined and retries are left
            if (retries > 0) {
                console.log(`Retrying Deepgram request, retries left: ${retries}`);
                yield new Promise((resolve) => setTimeout(resolve, 2000)); // Wait before retry
                return yield checkDeepgramUsages(requestId, retries - 1);
            }
            throw new Error("Deepgram usage details are unavailable after retries.");
        }
        catch (error) {
            console.log("Getting error while checking deepgram usage", error);
            logger_service_1.logger.error(`Getting error while checking deepgram usage: ${error}`);
            throw new Error("Getting error while checking deepgram usage");
        }
    });
}
function openAIResponse(content, isFlag) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const openai = new openai_1.default({
                apiKey: process.env.THEMATIC_ANALYTIC_KEY || "",
            });
            let contentMsg = [];
            if (isFlag === "summary") {
                contentMsg = [
                    {
                        role: "user",
                        content: `${content}\n You are ChatGPT-4o-latest, a large language model trained by OPENAI, based on chatgpt-4o-latest architecture. I have pasted transcribed notes from 1 message/speech below. Your task is to do a detailed review of the notes and summarize the message/speech calling out key references.`,
                    },
                ];
            }
            else if (isFlag === "keyThemes") {
                contentMsg = [
                    {
                        role: "user",
                        content: `${content}\n You are ChatGPT-4o-latest, a large language model trained by OPENAI, based on chatgpt-4o-latest architecture. I have pasted transcribed notes from 1 message/speech below. Your task is to do a detailed review of the notes and give key themes with references in a tabular format.`,
                    },
                ];
            }
            const response = yield openai.chat.completions.create({
                model: "chatgpt-4o-latest",
                messages: contentMsg,
                max_tokens: 16383,
                temperature: 0.3,
                top_p: 1.0,
                frequency_penalty: 0.0,
                presence_penalty: 0.0,
            });
            return { StatusCode: api_response_1.StatusCode.Ok, data: response };
        }
        catch (error) {
            console.log("Getting error while openAI API is processing", error);
            logger_service_1.logger.error(`Getting error while openAI API is processing: ${error}`);
            throw new Error("Getting error while openAI API is processing");
        }
    });
}
// export const exportPDF = async (req: any, res: Response) => {
//   try {
//     const { _id, mediaId } = req.query;
//     const getTranscribeResponse = await inputFile.aggregate([
//       {
//         $match: {
//           "file._id": new mongoose.Types.ObjectId(_id),
//         },
//       },
//       {
//         $project: {
//           _id: 1,
//           file: {
//             $filter: {
//               input: "$file",
//               as: "item",
//               cond: {
//                 $eq: ["$$item._id", new mongoose.Types.ObjectId(_id)], // Match the specific file._id
//               },
//             },
//           },
//         },
//       },
//     ]);
//     const thematicAnalysesResponse = await thematicAnalysis.findOne({
//       mediaId: mediaId,
//     });
//     const thematicArray = [thematicAnalysesResponse.response];
//     const summaryArray = [getTranscribeResponse[0].file[0].summary];
//     const keyThemesArray = [getTranscribeResponse[0].file[0].keyThemes];
//     const convertMDXToPlainText = async (mdxContent: any) => {
//       try {
//         // Compile MDX to JSX and extract the plain text from the compiled result
//         const compiled = await compile(mdxContent, {
//           outputFormat: "function-body",
//         });
//         const textContent = String(compiled).replace(/<\/?[^>]+(>|$)/g, ""); // Strip HTML tags
//         return textContent;
//       } catch (error) {
//         console.error("Error converting MDX to plain text:", error);
//         return ""; // Return an empty string if conversion fails
//       }
//     };
//     // Function to create PDF
//     const createPDF = async () => {
//       const doc: any = new PDFDocument();
//       const filePath = "output1.pdf";
//       doc.pipe(fs.createWriteStream(filePath));
//       // Set title
//       doc.fontSize(25).text("Response Data", { align: "center" });
//       // Add summary content to the PDF
//       doc.fontSize(16).text("Summary Data", { underline: true, margin: 20 });
//       if (summaryArray.length > 0) {
//         for (const item of summaryArray) {
//           const textContent = await convertMDXToPlainText(item); // Convert MDX to plain text
//           doc.fontSize(12).text(textContent, { indent: 20 });
//         }
//       } else {
//         doc.fontSize(12).text("No summary data available.", { indent: 20 });
//       }
//       doc.moveDown();
//       // Add key themes content to the PDF
//       doc.fontSize(16).text("Key Themes", { underline: true, margin: 20 });
//       if (keyThemesArray.length > 0) {
//         for (const item of keyThemesArray) {
//           const textContent = await convertMDXToPlainText(item); // Convert MDX to plain text
//           doc.fontSize(12).text(textContent, { indent: 20 });
//         }
//       } else {
//         doc.fontSize(12).text("No key themes data available.", { indent: 20 });
//       }
//       doc.moveDown();
//       // Add thematic analysis content to the PDF
//       doc
//         .fontSize(16)
//         .text("Thematic Analysis", { underline: true, margin: 20 });
//       if (thematicArray.length > 0) {
//         for (const item of thematicArray) {
//           const textContent = await convertMDXToPlainText(item); // Convert MDX to plain text
//           doc.fontSize(12).text(textContent, { indent: 20 });
//         }
//       } else {
//         doc.fontSize(12).text("No thematic data available.", { indent: 20 });
//       }
//       // Finalize the PDF
//       doc.end();
//       console.log(`PDF created successfully at ${filePath}`);
//     };
//     // Call the function to create the PDF
//     createPDF().catch((err) => {
//       console.error("Error creating PDF:", err);
//     });
//   } catch (error) {
//     console.log("Getting error while making pdf", error);
//     logger.error(`Getting error while making pdf: ${error}`);
//     throw new Error("Getting error while making pdf");
//   }
// };
const addRecordedFile = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    try {
        const { model, transcriptionId, isRecorded, workspaceId } = req.body;
        if (!workspaceId) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.workspace.workspaceNotFound);
        }
        if (req.user.userType != utills_1.USER_TYPE.USER) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.insufficient_Permissions);
        }
        if (!req.files) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        if (req.files[0].size > 209715200) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Failed to upload file, Your file is larger than the 200MB size limit.");
        }
        const duration = (yield (0, get_video_duration_1.getVideoDurationInSeconds)(req.files[0].path)) / 60;
        const deepgramResponse = yield postDataToDeepgram(req.files[0].path.replace(/\\/g, "/"), model);
        // const fileName = req.files[0].path.replace("public/", process.env.FILE_URL);
        const fileName = req.files[0].path.replace(/^public[\\/]/, "");
        const thumbnailURL = yield takeScreenshot(req.files[0].path);
        if (deepgramResponse.StatusCode === api_response_1.StatusCode.Ok) {
            const deepgramUsages = yield checkDeepgramUsages((_b = (_a = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _a === void 0 ? void 0 : _a.metadata) === null || _b === void 0 ? void 0 : _b.request_id);
            const deepgramTranscript = (_g = (_f = (_e = (_d = (_c = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _c === void 0 ? void 0 : _c.results) === null || _d === void 0 ? void 0 : _d.channels[0]) === null || _e === void 0 ? void 0 : _e.alternatives[0]) === null || _f === void 0 ? void 0 : _f.transcript) !== null && _g !== void 0 ? _g : "";
            // const summaryResponse = await openAIResponse(
            //   deepgramTranscript,
            //   "summary"
            // );
            // const keyThemesResponse = await openAIResponse(`
            //   deepgramTranscript,
            //   "keyThemes"
            // );
            const createInputFile = yield input_file_entity_1.inputFile.create({
                file: {
                    _id: new mongoose_1.default.Types.ObjectId(),
                    fileName: req.files[0].originalname,
                    // duration: duration ? duration.toFixed(2) : 0,`
                    duration: duration,
                    model: model,
                    status: "Completed",
                    fileURL: fileName,
                    thumbnailURL,
                    deepgram: deepgramResponse.data,
                    // summary: summaryResponse.data.choices[0].message.content.trim(),
                    // keyThemes: keyThemesResponse.data.choices[0].message.content.trim(),
                },
                amount: Number(deepgramUsages.data.toFixed(0, 3)),
                userId: new mongoose_1.default.Types.ObjectId((_h = req === null || req === void 0 ? void 0 : req.user) === null || _h === void 0 ? void 0 : _h._id), //THIS CAN BE REMOVED
                // NEW ADDITIONS IN CONTENT PRO
                isRecorded,
                workspaceId,
                owner: new mongoose_1.default.Types.ObjectId((_j = req === null || req === void 0 ? void 0 : req.user) === null || _j === void 0 ? void 0 : _j._id), // OWNER OF FILE
                users: [new mongoose_1.default.Types.ObjectId((_k = req === null || req === void 0 ? void 0 : req.user) === null || _k === void 0 ? void 0 : _k._id)], // USERS ARRAY
            });
            const createInputFileResponse = createInputFile.toObject();
            createInputFileResponse.transcriptionId = transcriptionId;
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, "File Upload successfully", createInputFileResponse);
        }
        else {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Failed to upload file.");
        }
    }
    catch (error) {
        console.log("Getting error while upload file and transcribe the file", error);
        logger_service_1.logger.error(`Getting error while upload file and transcribe the file : ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.addRecordedFile = addRecordedFile;
const takeScreenshot = (filePath) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const videoExtensions = [
            ".mp4",
            ".avi",
            ".mov",
            ".webm",
            ".mkv",
            ".flv",
            ".wmv",
            ".m4v",
        ];
        // Extract the file extension from the file path
        const fileExtension = filePath
            .slice(filePath.lastIndexOf("."))
            .toLowerCase();
        if (!videoExtensions.includes(fileExtension)) {
            return "";
        }
        const screenshotPath = yield screenshotService.takeScreenshot(
        // "public/input-file/javascript_in_100_seconds_1729231055125.webm",
        filePath, "public/screenshots", 5 // Take screenshot at 5 seconds
        );
        let fullPath = "screenshots/" + screenshotPath;
        return fullPath;
    }
    catch (error) {
        console.log("Getting error while taking screenshot for video", error);
        logger_service_1.logger.error(`Getting error while taking screenshot for video : ${error}`);
    }
});
