"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRecordedFile = exports.thematicAnalytic = exports.deleteOutPutFiles = exports.getAllOutPutFile = exports.exportOutPutFile = exports.youTubeUpload = exports.getById = exports.deleteFiles = exports.get = exports.editInputFile = exports.add = exports.createBatch = void 0;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const input_file_entity_1 = require("../entities/input-file.entity");
const outPutFileSchema_1 = require("../entities/outPutFileSchema");
const get_video_duration_1 = require("get-video-duration");
const sdk_1 = require("@deepgram/sdk");
const fs = __importStar(require("fs"));
const mongoose_1 = __importDefault(require("mongoose"));
const youtube_dl_exec_1 = __importDefault(require("youtube-dl-exec"));
const path_1 = __importDefault(require("path"));
const openai_1 = __importDefault(require("openai"));
const thematicAnalysisSchema_1 = require("../entities/thematicAnalysisSchema");
const api_response_1 = require("../../api.response");
const utills_1 = require("../../service/utills");
const screenshot_service_1 = require("../../service/screenshot.service");
const workspace_entity_1 = __importDefault(require("../../workspace/entities/workspace.entity"));
const index_1 = require("../../index");
const socket_1 = require("../../socket/socket");
const axios_1 = __importDefault(require("axios"));
const screenshotService = new screenshot_service_1.ScreenshotService();
const handleSocketMessage = (userId, eventName, data) => {
    if (socket_1.userSocketMap[userId]) {
        index_1.io.to(socket_1.userSocketMap[userId]).emit(eventName, data);
    }
};
// =========================== CREATE BATCH WHEN MULTIPLE FILES =========================
const createBatch = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d, _e;
    const { transcriptionId, isFile, file, workspaceId } = req.body;
    const batchName = isFile
        ? yield generateBatch((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id)
        : `yt-${yield generateBatch((_b = req === null || req === void 0 ? void 0 : req.user) === null || _b === void 0 ? void 0 : _b._id)}`;
    try {
        let createdData = yield input_file_entity_1.inputFile.create({
            file,
            batchName,
            userId: new mongoose_1.default.Types.ObjectId((_c = req === null || req === void 0 ? void 0 : req.user) === null || _c === void 0 ? void 0 : _c._id),
            amount: 0,
            transcriptionId,
            // ADD WORKSPACE ID ALSO IN CREATE BATCH API
            workspaceId,
            owner: new mongoose_1.default.Types.ObjectId((_d = req === null || req === void 0 ? void 0 : req.user) === null || _d === void 0 ? void 0 : _d._id), // OWNER OF FILE
            users: [new mongoose_1.default.Types.ObjectId((_e = req === null || req === void 0 ? void 0 : req.user) === null || _e === void 0 ? void 0 : _e._id)], // USERS ARRAY
        });
        (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, "Batch created successfully", createdData);
    }
    catch (error) {
        console.log("Error while creating batch:", error);
        logger_service_1.logger.error(`Error while creating batch: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.createBatch = createBatch;
// =========================== ADD SELECTED LOCAL FILE ==================================
const add = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    let userId = (_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id;
    let createInputFile = null;
    let existingEntry = null;
    let initialFileData = null;
    const { model, transcriptionId, fileUniqueId, fileName, duration, isRecorded, workspaceId, } = req.body;
    try {
        if (!workspaceId) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.workspace.workspaceNotFound);
        }
        if (!req.files) {
            handleSocketMessage(userId, "upload-error", {
                statusCode: api_response_1.StatusCode.BadRequest,
                message: api_response_1.messages.allFieldsRequired,
            });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        let workSpaceData = yield workspace_entity_1.default.findById(new mongoose_1.default.Types.ObjectId(workspaceId));
        // Check if the user is the owner of the workspace
        if (!workSpaceData || !workSpaceData.owner.equals(req.user._id)) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.inputFile.noPermissionToAdd);
        }
        // if (req.files.length > 10) {
        //   for (let index = 0; index < req.files; index++) {
        //     const element = req.files[index];
        const files = Array.isArray(req.files) ? req.files : [req.files];
        // Validate file sizes early
        if (files.some((file) => file.size > 209715200)) {
            handleSocketMessage(userId, "upload-error", {
                statusCode: api_response_1.StatusCode.BadRequest,
                message: "Failed to upload file, Your file is larger than the 200MB size limit.",
            });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Failed to upload file, Your file is larger than the 200MB size limit.");
        }
        // Create initial document data
        initialFileData = {
            _id: new mongoose_1.default.Types.ObjectId(),
            status: "Processing",
            fileName,
            duration: Math.ceil(duration),
            model: [],
            totalAmount: 0,
        };
        // First check if document exists
        existingEntry = yield input_file_entity_1.inputFile.findOne({ transcriptionId });
        // Handle document creation/update based on existence
        if (existingEntry) {
            createInputFile = yield input_file_entity_1.inputFile.findOneAndUpdate({ transcriptionId }, {
                $push: { file: initialFileData },
                amount: 0,
            }, { new: true });
        }
        else {
            createInputFile = yield input_file_entity_1.inputFile.create({
                file: [initialFileData],
                userId: new mongoose_1.default.Types.ObjectId(userId),
                amount: 0,
                transcriptionId,
                // NEW ADDITIONS IN CONTENT PRO
                isRecorded,
                workspaceId,
                owner: new mongoose_1.default.Types.ObjectId(userId), // OWNER OF FILE
                users: [new mongoose_1.default.Types.ObjectId(userId)], // USERS ARRAY
            });
        }
        // Emit socket event if socket exists
        handleSocketMessage(userId, "initial-data-loaded");
        let totalAmount = 0;
        // Process files with better error handling
        const processFile = (file) => __awaiter(void 0, void 0, void 0, function* () {
            try {
                const filePath = file.path.replace(/\\/g, "/");
                const fileURL = filePath.replace("public/", process.env.FILE_URL);
                const thumbnailURL = yield takeScreenshot(file.path);
                // Get duration and process through Deepgram concurrently
                const [deepgramResponse, durationInSeconds] = yield Promise.all([
                    postDataToDeepgram(filePath, model),
                    (0, get_video_duration_1.getVideoDurationInSeconds)(filePath),
                ]).catch((err) => console.log(err));
                if (!deepgramResponse ||
                    deepgramResponse.StatusCode !== api_response_1.StatusCode.Ok) {
                    // handleSocketMessage(userId, "upload-error", {
                    //   statusCode: StatusCode.BADREQUEST,
                    //   message: "Transcribing Failed!",
                    //   data: {
                    //     fileId: createInputFile?._id,
                    //     _id: initialFileData?._id,
                    //   },
                    // });
                    throw new Error("Deepgram processing failed");
                }
                // Get Deepgram usage
                const deepgramUsages = { data: 0 };
                // const deepgramUsages = await checkDeepgramUsages(
                //   deepgramResponse?.data?.metadata?.request_id
                // );
                // if (!deepgramUsages || !deepgramUsages.data) {
                //   handleSocketMessage(userId, "upload-error", {
                //     statusCode: StatusCode.BADREQUEST,
                //     message: "Transcribing Failed!",
                //     data: {
                //       fileId: createInputFile?._id,
                //       _id: initialFileData?._id,
                //     },
                //   });
                //   throw new Error("Failed to get Deepgram usage data");
                // }
                // const deepgramTranscript =
                //   deepgramResponse?.data?.results?.channels[0]?.alternatives[0]
                //     ?.transcript;
                // Run both openAIResponse calls concurrently
                // const [summaryResponse, keyThemesResponse]: any = await Promise.all([
                //   openAIResponse(deepgramTranscript, "summary"),
                //   openAIResponse(deepgramTranscript, "keyThemes"),
                // ]).catch((error) => {
                //   handleSocketMessage(userId, "upload-error", {
                //     statusCode: StatusCode.BadRequest,
                //     message: "Failed to get Summary or Key Themes",
                //   });
                // });
                totalAmount += deepgramUsages.data;
                return {
                    _id: initialFileData === null || initialFileData === void 0 ? void 0 : initialFileData._id,
                    fileName: file.originalname,
                    duration: Math.ceil(durationInSeconds),
                    model,
                    status: "Completed",
                    fileURL,
                    deepgram: deepgramResponse.data,
                    // summary: summaryResponse.data.choices[0].message.content.trim(),
                    // keyThemes: keyThemesResponse.data.choices[0].message.content.trim(),
                    fileId: createInputFile._id,
                    transcriptionId,
                    fileUniqueId,
                    thumbnailURL,
                };
            }
            catch (error) {
                // handleSocketMessage(userId, "upload-error", {
                //   statusCode: StatusCode.BADREQUEST,
                //   message: `Error processing file ${file.originalname}:`,
                //   data: {
                //     fileId: createInputFile?._id,
                //     _id: initialFileData?._id,
                // fileUniqueId
                //   },
                // });
                console.error(`Error processing file ${file.originalname}:`, error);
                throw error;
            }
        });
        // Process files and handle errors
        const [processedFile] = yield Promise.all(files.map(processFile));
        if (!processedFile) {
            handleSocketMessage(userId, "upload-error", {
                statusCode: api_response_1.StatusCode.BadRequest,
                message: "File processing failed",
                data: {
                    fileId: createInputFile === null || createInputFile === void 0 ? void 0 : createInputFile._id,
                    _id: initialFileData === null || initialFileData === void 0 ? void 0 : initialFileData._id,
                    fileUniqueId,
                },
            });
            throw new Error("File processing failed");
        }
        // Update document with processed data
        const updatedDoc = yield input_file_entity_1.inputFile.findOneAndUpdate({
            transcriptionId,
            "file._id": initialFileData === null || initialFileData === void 0 ? void 0 : initialFileData._id,
        }, {
            $set: {
                "file.$": processedFile,
                amount: Number(totalAmount.toFixed(3)),
            },
        }, { new: true });
        if (!updatedDoc) {
            handleSocketMessage(userId, "upload-error", {
                statusCode: api_response_1.StatusCode.BadRequest,
                message: "Failed to process file",
                data: {
                    fileId: createInputFile === null || createInputFile === void 0 ? void 0 : createInputFile._id,
                    _id: initialFileData === null || initialFileData === void 0 ? void 0 : initialFileData._id,
                    fileUniqueId,
                },
            });
            throw new Error("Failed to update document with processed data");
        }
        // Emit socket event if socket exists
        handleSocketMessage(userId, "upload-success", {
            message: "File uploaded successfully",
            data: processedFile,
        });
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, "File uploaded successfully", processedFile);
    }
    catch (error) {
        // If there was an error and we created a document, clean it up
        if (createInputFile) {
            try {
                yield input_file_entity_1.inputFile.deleteOne({ _id: createInputFile._id });
            }
            catch (cleanupError) {
                console.error("Error cleaning up after failure:", cleanupError);
            }
        }
        console.error("Detailed error:", error);
        logger_service_1.logger.error(`Error while uploading and transcribing file: ${error.message}\nStack: ${error.stack}`);
        handleSocketMessage(userId, "upload-error", {
            statusCode: api_response_1.StatusCode.InternalServerError,
            message: "Failed to process file",
            data: {
                fileId: createInputFile === null || createInputFile === void 0 ? void 0 : createInputFile._id,
                _id: initialFileData === null || initialFileData === void 0 ? void 0 : initialFileData._id,
                fileUniqueId,
            },
        });
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, error.message || api_response_1.messages.internalServerError);
    }
});
exports.add = add;
//============================ UPDATE INPUT FILES========================//
const editInputFile = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { batchName, _id } = req.body;
        let isInputFile = yield input_file_entity_1.inputFile.findById(_id);
        if (!isInputFile) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.inputFile.invalidInputFile);
        }
        let updatedInputFile = yield input_file_entity_1.inputFile.findByIdAndUpdate(_id, { batchName: batchName }, { new: true });
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.inputFile.updateSuccess, updatedInputFile);
    }
    catch (error) {
        console.log("Getting error while edit input file ::", error);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.editInputFile = editInputFile;
// =========================== GET INPUT FILE =========================== /
// export const get = async (req: any, res: Response) => {
//   try {
//     const { take, page, search, isBatch, workspaceId } = req.query;
//     delete req.query.take;
//     delete req.query.page;
//     delete req.query.search;
//     delete req.query.isBatch;
//     delete req.query.workspaceId;
//     if (!workspaceId) {
//       return sendMessageResponse(
//         req,
//         res,
//         StatusCode.BadRequest,
//         messages.workspace.workspaceNotFound
//       );
//     }
//     if (req.user.userType != "USER") {
//       return sendMessageResponse(
//         req,
//         res,
//         StatusCode.BadRequest,
//         messages.insufficient_Permissions
//       );
//     }
//     // PAGINATION
//     const takePerPage = Number(take) || 10;
//     let pageCount = Number(page) || 1;
//     if (pageCount == 0) {
//       pageCount = 1;
//     }
//     const skip = (pageCount - 1) * takePerPage;
//     // Create QUERY
//     let query: any = {};
//     // GLOBAL FILTER
//     if (search) {
//       query = {
//         ...query,
//         $and: [
//           {
//             $or: [
//               { "file.fileName": { $regex: search, $options: "i" } },
//               { batchName: { $regex: search, $options: "i" } },
//             ],
//           },
//         ],
//       };
//     }
//     if (isBatch === "true") {
//       query.batchName = { $ne: null };
//     } else if (isBatch === "false") {
//       query.batchName = { $eq: null };
//     }
//     const fileInputResponse = await inputFile.aggregate([
//       {
//         $match: query,
//       },
//       {
//         $sort: {
//           createdAt: -1,
//         },
//       },
//       // {
//       //   $match: {
//       //     userId: new mongoose.Types.ObjectId(req?.user?._id),
//       //   },
//       // },
//       {
//         $match: {
//           workspaceId: new mongoose.Types.ObjectId(workspaceId),
//         },
//       },
//       {
//         $match: {
//           // Check if the userId exists in the 'users' array
//           users: {
//             $in: [new mongoose.Types.ObjectId(req?.user?._id)],
//           },
//         },
//       },
//       {
//         $facet: {
//           metadata: [{ $count: "totalCount" }],
//           data: [{ $skip: skip }, { $limit: takePerPage }],
//         },
//       },
//     ]);
//     const metadata = fileInputResponse[0].metadata[0];
//     const totalCount = metadata ? metadata.totalCount : 0;
//     // PAGINATION
//     const totalPages = Math.ceil(totalCount / takePerPage);
//     const nextPage = pageCount < totalPages ? pageCount + 1 : null;
//     const prevPage = pageCount > 1 ? pageCount - 1 : null;
//     const responseData = {
//       docs: fileInputResponse[0]?.data || [],
//       count: totalCount,
//       pages: totalPages,
//       currentPage: Number(page),
//       nextPage,
//       prevPage,
//     };
//     return sendDataResponse(
//       req,
//       res,
//       StatusCode.Ok,
//       "Files data fetch successfully.",
//       responseData
//     );
//   } catch (error) {
//     console.log("Getting error while get the input file", error);
//     logger.error(`Getting error while get the input file : ${error}`);
//     return sendMessageResponse(
//       req,
//       res,
//       StatusCode.InternalServerError,
//       messages.internalServerError
//     );
//   }
// };
const get = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    try {
        const { take, page, search, isBatch, workspaceId, startDate, endDate } = req.query;
        delete req.query.take;
        delete req.query.page;
        delete req.query.search;
        delete req.query.isBatch;
        delete req.query.workspaceId;
        delete req.query.startDate;
        delete req.query.endDate;
        if (!workspaceId) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.workspace.workspaceNotFound);
        }
        if (req.user.userType != "USER") {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.insufficient_Permissions);
        }
        // PAGINATION
        const takePerPage = Number(take) || 10;
        let pageCount = Number(page) || 1;
        if (pageCount == 0) {
            pageCount = 1;
        }
        const skip = (pageCount - 1) * takePerPage;
        // Create QUERY
        let query = {};
        // GLOBAL FILTER
        if (search) {
            query = Object.assign(Object.assign({}, query), { $and: [
                    {
                        $or: [
                            { "file.fileName": { $regex: search, $options: "i" } },
                            { batchName: { $regex: search, $options: "i" } },
                        ],
                    },
                ] });
        }
        // Filter by isBatch
        if (isBatch === "true") {
            query.batchName = { $ne: null };
        }
        else if (isBatch === "false") {
            query.batchName = { $eq: null };
        }
        // Filter by createdAt range
        if (startDate || endDate) {
            query.createdAt = {};
            if (startDate) {
                query.createdAt.$gte = new Date(startDate);
            }
            if (endDate) {
                query.createdAt.$lte = new Date(endDate);
            }
        }
        const fileInputResponse = yield input_file_entity_1.inputFile.aggregate([
            {
                $match: query,
            },
            {
                $sort: {
                    createdAt: -1,
                },
            },
            {
                $match: {
                    workspaceId: new mongoose_1.default.Types.ObjectId(workspaceId),
                },
            },
            {
                $match: {
                    users: {
                        $in: [new mongoose_1.default.Types.ObjectId((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id)],
                    },
                },
            },
            {
                $facet: {
                    metadata: [{ $count: "totalCount" }],
                    data: [{ $skip: skip }, { $limit: takePerPage }],
                },
            },
        ]);
        const metadata = fileInputResponse[0].metadata[0];
        const totalCount = metadata ? metadata.totalCount : 0;
        // PAGINATION
        const totalPages = Math.ceil(totalCount / takePerPage);
        const nextPage = pageCount < totalPages ? pageCount + 1 : null;
        const prevPage = pageCount > 1 ? pageCount - 1 : null;
        const responseData = {
            docs: ((_b = fileInputResponse[0]) === null || _b === void 0 ? void 0 : _b.data) || [],
            count: totalCount,
            pages: totalPages,
            currentPage: Number(page),
            nextPage,
            prevPage,
        };
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, "Files data fetched successfully.", responseData);
    }
    catch (error) {
        console.log("Getting error while getting the input file", error);
        logger_service_1.logger.error(`Getting error while getting the input file : ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.get = get;
// =========================== GENERATE BATCH =========================== /
function generateBatch(userId) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const count = yield input_file_entity_1.inputFile.countDocuments({
                // userId: userId,
                owner: userId,
                batchName: { $ne: null },
            });
            return `Batch-${count}`;
        }
        catch (error) {
            console.log("Getting error while generate batch", error);
            logger_service_1.logger.error(`Getting error while add-user : ${error}`);
            throw new Error("Getting error while generate batch");
        }
    });
}
// =========================== POST DATA TO DEEPGRAM TRANSCRIBE =========================== /
function postDataToDeepgram(url, model) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const deepgram = (0, sdk_1.createClient)(process.env.DEEPGRAM_KEY);
            const transcribeOptions = {
                model: "nova-2",
                smart_format: true,
                // summarize: "v2",
                // topics: true, //model.includes("TopicDetection") ? true : false,
                // diarize: model.includes("Diarization") ? true : false,
                // paragraphs: model.includes("Paragraphs") ? true : false,
            };
            const { result, error } = yield deepgram.listen.prerecorded.transcribeFile(fs.createReadStream(url), transcribeOptions);
            if (error) {
                console.log("Error in Post Data to Deepgram 1:: ", error);
                return { StatusCode: api_response_1.StatusCode.BadRequest };
            }
            return { StatusCode: api_response_1.StatusCode.Ok, data: result };
        }
        catch (error) {
            console.log("Error in Post Data to Deepgram 2:: ", error);
            return { StatusCode: api_response_1.StatusCode.BadRequest };
        }
    });
}
// =========================== DELETE INPUT FILE & BATCH =========================== /
// export const deleteFiles = async (req: any, res: Response) => {
//   try {
//     if (
//       !Array.isArray(req.body.ids) ||
//       req.body.ids.length === 0 ||
//       req.body.ids.every((id: any) => id === null)
//     ) {
//       return sendMessageResponse(
//         req,
//         res,
//         StatusCode.BadRequest,
//         "Please select files to delete."
//       );
//     }
//     const _fileIds = req.body.ids.map(
//       (id: string) => new mongoose.Types.ObjectId(id)
//     );
//     const ownerId = req.user?._id;
//     // Find all documents containing the files with the given IDs
//     const documents = await inputFile.find({
//       "file._id": { $in: _fileIds },
//       ownerId: ownerId,
//     });
//     if (!documents || documents.length === 0) {
//       return sendMessageResponse(
//         req,
//         res,
//         StatusCode.BadRequest,
//         "No files found."
//       );
//     }
//     for (const doc of documents) {
//       const fileArray = doc.file;
//       // Filter out the files to be deleted
//       const updatedFileArray = fileArray.filter(
//         (file: any) =>
//           !_fileIds.some((fileId: mongoose.Types.ObjectId) =>
//             fileId.equals(file._id)
//           )
//       );
//       // If no files are left after deletion, delete the entire document
//       if (updatedFileArray.length === 0) {
//         await inputFile.deleteOne({ _id: doc._id });
//       } else {
//         // Update the document with the remaining files
//         await inputFile.updateOne(
//           { _id: doc._id },
//           { $set: { file: updatedFileArray } }
//         );
//       }
//     }
//     return sendMessageResponse(
//       req,
//       res,
//       StatusCode.Ok,
//       "Selected files deleted successfully."
//     );
//   } catch (error) {
//     console.log("Error while deleting the files:", error);
//     logger.error(`Error while deleting the files: ${error}`);
//     return sendMessageResponse(
//       req,
//       res,
//       StatusCode.InternalServerError,
//       messages.internalServerError
//     );
//   }
// };
const deleteFiles = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    try {
        if (!Array.isArray(req.body.ids) ||
            req.body.ids.length === 0 ||
            req.body.ids.every((id) => id === null)) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Please select files to delete.");
        }
        const _fileIds = req.body.ids.map((id) => new mongoose_1.default.Types.ObjectId(id));
        const ownerId = (_a = req.user) === null || _a === void 0 ? void 0 : _a._id;
        const documents = yield input_file_entity_1.inputFile.find({
            "file._id": { $in: _fileIds },
        });
        if (!documents || documents.length === 0) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "No files found.");
        }
        const ownedFiles = [];
        const nonOwnedFiles = [];
        for (const doc of documents) {
            if ((_b = doc.owner) === null || _b === void 0 ? void 0 : _b.equals(ownerId)) {
                // Filter files to delete based on file._id
                const filesToDelete = doc.file.filter((file) => _fileIds.some((fileId) => fileId.equals(file._id)));
                ownedFiles.push(...filesToDelete.map((file) => file._id));
                // Create an updated list of remaining files
                const remainingFiles = doc.file.filter((file) => !filesToDelete.some((delFile) => String(delFile._id) === String(file._id)));
                if (remainingFiles.length === 0) {
                    yield input_file_entity_1.inputFile.deleteOne({ _id: doc._id });
                }
                else {
                    yield input_file_entity_1.inputFile.updateOne({ _id: doc._id }, { $set: { file: remainingFiles } });
                }
            }
            else {
                const nonOwnedFilesInDoc = doc.file.filter((file) => _fileIds.some((fileId) => fileId.equals(file._id)));
                nonOwnedFiles.push(...nonOwnedFilesInDoc.map((file) => file._id));
            }
        }
        let message;
        if (ownedFiles.length > 0 && nonOwnedFiles.length === 0) {
            message = "Selected files deleted successfully.";
        }
        else if (ownedFiles.length > 0 && nonOwnedFiles.length > 0) {
            message = `Selected files deleted successfully. However, ${nonOwnedFiles.length} file(s) were not deleted as they are not owned by you.`;
        }
        else {
            message = "No files were deleted as they are not owned by you.";
        }
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, message);
    }
    catch (error) {
        console.log("Error while deleting the files:", error);
        logger_service_1.logger.error(`Error while deleting the files: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.deleteFiles = deleteFiles;
// =========================== INPUT FILE GET BY ID =========================== /
const getById = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const _id = req.params.id;
        const findInputFile = yield input_file_entity_1.inputFile.aggregate([
            {
                $match: {
                    _id: new mongoose_1.default.Types.ObjectId(_id),
                },
            },
            {
                $lookup: {
                    from: "thematic-analyses",
                    localField: "_id",
                    foreignField: "mediaId",
                    as: "thematicAnalyses",
                },
            },
            {
                $project: {
                    _id: 1,
                    file: 1,
                    batchName: 1,
                    createdAt: 1,
                    userId: 1,
                    owner: 1,
                    isRecorded: 1,
                    workspaceId: 1,
                    // thematicAnalyses: "$thematicAnalyses",
                    thematicAnalyses: {
                        $slice: ["$thematicAnalyses", -1, 1],
                    },
                },
            },
        ]);
        if (!findInputFile) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, "Record not found.");
        }
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, "Files data fetch successfully.", findInputFile[0]);
    }
    catch (error) {
        console.log("Getting error while fine result by id the input file", error);
        logger_service_1.logger.error(`Getting error while fine result by id the input file : ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.getById = getById;
// const processYouTubeURL = async (ytURL: string, userId: string, data: any) => {
//   let totalAmount = 0;
//   let model: any = [];
//   const cleanFileName = (title: string) => {
//     return title
//       .toString()
//       .toLowerCase()
//       .replace(/[^a-z0-9]+/g, "_")
//       .replace(/^_+|_+$/g, "")
//       .concat(`_${Date.now()}`);
//   };
//   const videoInfo: any = await youtubedl(ytURL, {
//     dumpJson: true, // Ensures structured JSON output
//     noWarnings: true,
//     noCheckCertificates: true,
//     preferFreeFormats: true,
//     youtubeSkipDashManifest: true,
//   });
//   const title = videoInfo.title as string;
//   const thumbnailURL = videoInfo.thumbnail as string;
//   const fileName = cleanFileName(title);
//   const initialPath = process.env.PROJECT_PATH ?? "";
//   const outputPath = path.join(initialPath, "input-file", `${fileName}.webm`);
//   await youtubedl(ytURL, {
//     output: outputPath,
//   }).catch((err) => {
//     handleSocketMessage(userId, "upload-error", {
//       statusCode: StatusCode.BadRequest,
//       message: "Failed to upload the file",
//       data,
//     });
//   });
//   const duration = await getVideoDurationInSeconds(
//     outputPath.replace(/\\/g, "/")
//   ).catch((err) => {
//     handleSocketMessage(userId, "upload-error", {
//       statusCode: StatusCode.BadRequest,
//       message: "Failed to process the file",
//       data,
//     });
//     throw err;
//   });
//   const deepgramResponse = await postDataToDeepgram(
//     outputPath.replace(/\\/g, "/"),
//     model
//   ).catch((err) => {
//     handleSocketMessage(userId, "upload-error", {
//       statusCode: StatusCode.BadRequest,
//       message: "Failed to process the file",
//       data,
//     });
//     throw err;
//   });
//   const fileURL = `input-file/${fileName}.webm`;
//   if (deepgramResponse.StatusCode === StatusCode.Ok) {
//     const deepgramUsages = { data: 0 };
//     const deepgramTranscript =
//       deepgramResponse?.data?.results?.channels[0]?.alternatives[0]
//         ?.transcript ?? "";
//     const [summaryResponse, keyThemesResponse] = await Promise.all([
//       openAIResponse(deepgramTranscript, "summary"),
//       openAIResponse(deepgramTranscript, "keyThemes"),
//     ]).catch((err) => {
//       handleSocketMessage(userId, "upload-error", {
//         statusCode: StatusCode.BadRequest,
//         message: "Failed to get Summary or Key Themes",
//       });
//       throw err;
//     });
//     totalAmount += deepgramUsages.data;
//     return {
//       fileName: title,
//       duration: Math.ceil(duration),
//       model,
//       status: "Completed",
//       fileURL,
//       thumbnailURL,
//       deepgram: deepgramResponse.data,
//       summary: summaryResponse.data.choices[0].message.content.trim(),
//       keyThemes: keyThemesResponse.data.choices[0].message.content.trim(),
//       totalAmount,
//     };
//   } else {
//     console.log("Error in deepgramResponse", deepgramResponse);
//     handleSocketMessage(userId, "upload-error", {
//       statusCode: StatusCode.BadRequest,
//       message: "Failed to Transcribe the file",
//       data,
//     });
//     throw new Error("Failed to Transcribe the file");
//   }
// };
const processYouTubeURL = (ytURL, userId, data) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d, _e, _f;
    let totalAmount = 0;
    let model = [];
    // Usage with your youtube-dl code
    const cleanFileName = (title) => {
        return title
            .toString()
            .toLowerCase()
            .replace(/[^a-z0-9]+/g, "_")
            .replace(/^_+|_+$/g, "")
            .concat(`_${Date.now()}`);
    };
    const videoInfo = yield (0, youtube_dl_exec_1.default)(ytURL, {
        dumpJson: true,
        noWarnings: true,
        noCheckCertificates: true,
        preferFreeFormats: true,
        youtubeSkipDashManifest: true,
    });
    const title = videoInfo.title;
    const thumbnailURL = videoInfo.thumbnail;
    const fileName = cleanFileName(title);
    const initialPath = (_a = process.env.PROJECT_PATH) !== null && _a !== void 0 ? _a : "";
    // Ensure screenshots folder exists
    const screenshotsPath = path_1.default.join(initialPath, "screenshots");
    if (!fs.existsSync(screenshotsPath)) {
        fs.mkdirSync(screenshotsPath, { recursive: true });
    }
    // Download and save the thumbnail
    const localThumbnailPath = path_1.default.join(screenshotsPath, `${fileName}.jpg`);
    const writer = fs.createWriteStream(localThumbnailPath);
    const response = yield (0, axios_1.default)({
        url: thumbnailURL,
        method: "GET",
        responseType: "stream",
    });
    response.data.pipe(writer);
    yield new Promise((resolve, reject) => {
        writer.on("finish", resolve);
        writer.on("error", reject);
    });
    // Output path for the video file
    const outputPath = path_1.default.join(initialPath, "input-file", `${fileName}.webm`);
    yield (0, youtube_dl_exec_1.default)(ytURL, {
        output: outputPath,
    }).catch((err) => {
        handleSocketMessage(userId, "upload-error", {
            statusCode: api_response_1.StatusCode.BadRequest,
            message: "Failed to upload the file",
            data,
        });
    });
    const duration = yield (0, get_video_duration_1.getVideoDurationInSeconds)(outputPath.replace(/\\/g, "/")).catch((err) => {
        handleSocketMessage(userId, "upload-error", {
            statusCode: api_response_1.StatusCode.BadRequest,
            message: "Failed to process the file",
            data,
        });
        throw err;
    });
    const deepgramResponse = yield postDataToDeepgram(outputPath.replace(/\\/g, "/"), model).catch((err) => {
        handleSocketMessage(userId, "upload-error", {
            statusCode: api_response_1.StatusCode.BadRequest,
            message: "Failed to process the file",
            data,
        });
        throw err;
    });
    const fileURL = `input-file/${fileName}.webm`;
    if (deepgramResponse.StatusCode === api_response_1.StatusCode.Ok) {
        const deepgramUsages = { data: 0 };
        const deepgramTranscript = (_f = (_e = (_d = (_c = (_b = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _b === void 0 ? void 0 : _b.results) === null || _c === void 0 ? void 0 : _c.channels[0]) === null || _d === void 0 ? void 0 : _d.alternatives[0]) === null || _e === void 0 ? void 0 : _e.transcript) !== null && _f !== void 0 ? _f : "";
        const [summaryResponse, keyThemesResponse] = yield Promise.all([
            openAIResponse(deepgramTranscript, "summary"),
            openAIResponse(deepgramTranscript, "keyThemes"),
        ]).catch((err) => {
            handleSocketMessage(userId, "upload-error", {
                statusCode: api_response_1.StatusCode.BadRequest,
                message: "Failed to get Summary or Key Themes",
            });
            throw err;
        });
        totalAmount += deepgramUsages.data;
        return {
            fileName: title,
            duration: Math.ceil(duration),
            model,
            status: "Completed",
            fileURL,
            thumbnailURL: `screenshots/${fileName}.jpg`, // Return local thumbnail path
            deepgram: deepgramResponse.data,
            summary: summaryResponse.data.choices[0].message.content.trim(),
            keyThemes: keyThemesResponse.data.choices[0].message.content.trim(),
            totalAmount,
        };
    }
    else {
        console.log("Error in deepgramResponse", deepgramResponse);
        handleSocketMessage(userId, "upload-error", {
            statusCode: api_response_1.StatusCode.BadRequest,
            message: "Failed to Transcribe the file",
            data,
        });
        throw new Error("Failed to Transcribe the file");
    }
});
const youTubeUpload = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c;
    const { youTubeURL, transcriptionId, fileUniqueId, isFolder, fileName, duration, workspaceId, } = req.body;
    if (!workspaceId) {
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.workspace.workspaceNotFound);
    }
    let initialFileData = null;
    let existingEntry = null;
    let createInputFile = null;
    let userId = (_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id;
    try {
        // Create initial document with "Processing" status and frontend data
        initialFileData = {
            _id: new mongoose_1.default.Types.ObjectId(),
            status: "Processing",
            fileName,
            duration: Math.ceil(duration),
            model: [],
            totalAmount: 0,
        };
        // Determine batchName based on the `isFolder` property
        const batchName = isFolder ? `yt-${yield generateBatch(userId)}` : null;
        // Find existing entry or create new one with initial processing status
        existingEntry = yield input_file_entity_1.inputFile.findOne({ transcriptionId });
        createInputFile = existingEntry
            ? yield input_file_entity_1.inputFile.findOneAndUpdate({ transcriptionId }, {
                $push: { file: initialFileData },
                amount: 0,
            }, { new: true })
            : yield input_file_entity_1.inputFile.create({
                file: [initialFileData],
                batchName,
                userId: new mongoose_1.default.Types.ObjectId(userId),
                amount: 0,
                transcriptionId,
                // NEW IMPLEMENTATION IN CONTENT PRO
                isRecorded: false,
                workspaceId,
                owner: new mongoose_1.default.Types.ObjectId((_b = req === null || req === void 0 ? void 0 : req.user) === null || _b === void 0 ? void 0 : _b._id), // OWNER OF FILE
                users: [new mongoose_1.default.Types.ObjectId((_c = req === null || req === void 0 ? void 0 : req.user) === null || _c === void 0 ? void 0 : _c._id)], // USERS ARRAY
            });
        // Emit socket event if socket exists
        handleSocketMessage(userId, "initial-data-loaded");
        // Send immediate response with processing status
        const initialResponse = createInputFile.toObject();
        initialResponse.transcriptionId = transcriptionId;
        initialResponse.fileUniqueId = fileUniqueId;
        // Send initial response
        // sendResponse(
        //   res,
        //   StatusCode.CREATE,
        //   "File upload started",
        //   initialResponse
        // );
        // Process the YouTube URL in the background
        const processedFileData = yield processYouTubeURL(youTubeURL, userId, {
            fileId: createInputFile._id,
            _id: initialFileData._id,
            fileUniqueId,
        });
        const wholeObj = Object.assign(Object.assign({}, processedFileData), { _id: initialFileData === null || initialFileData === void 0 ? void 0 : initialFileData._id, fileId: createInputFile._id });
        wholeObj.transcriptionId = transcriptionId;
        wholeObj.fileUniqueId = fileUniqueId;
        // Update the document with processed data
        yield input_file_entity_1.inputFile.findOneAndUpdate({
            transcriptionId,
            "file._id": initialFileData === null || initialFileData === void 0 ? void 0 : initialFileData._id,
        }, {
            $set: {
                "file.$": wholeObj,
                amount: Number(processedFileData.totalAmount.toFixed(3)),
            },
        });
        const createInputFileResponse = createInputFile.toObject();
        createInputFileResponse.transcriptionId = transcriptionId;
        createInputFileResponse.fileUniqueId = fileUniqueId;
        handleSocketMessage(userId, "upload-success", {
            message: "File uploaded successfully",
            data: wholeObj,
        });
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, "File uploaded successfully", wholeObj);
    }
    catch (error) {
        console.log("Error while uploading YouTube link:", error);
        logger_service_1.logger.error(`Error while uploading YouTube link: ${error}`);
        // handleSocketMessage(userId, "upload-error", {
        //   statusCode: StatusCode.BadRequest,
        //   message: "Failed to process file",
        //   data: {
        //     fileId: createInputFile?._id,
        //     _id: initialFileData?._id,
        //   },
        // });
        // Update status to Failed if there's an error
        if (initialFileData === null || initialFileData === void 0 ? void 0 : initialFileData._id) {
            yield input_file_entity_1.inputFile.findOneAndUpdate({
                transcriptionId,
                "file._id": initialFileData === null || initialFileData === void 0 ? void 0 : initialFileData._id,
            }, {
                $set: {
                    "file.$.status": "Failed",
                    "file.$.error": error.message,
                },
            });
        }
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.youTubeUpload = youTubeUpload;
// =========================== OUT PUT FILE =========================== /
const exportOutPutFile = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    try {
        const { _id, exportType } = req.body;
        if (!_id || !exportType) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Id & export type is required");
        }
        const findInputFile = yield input_file_entity_1.inputFile.findById({
            _id,
        });
        if (!findInputFile) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Please check your selected Id");
        }
        const saveOutPutFile = yield outPutFileSchema_1.outPutFile.create({
            file: findInputFile.file,
            batchName: findInputFile.batchName,
            userId: new mongoose_1.default.Types.ObjectId((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id),
            exportType: exportType,
            inputFileId: new mongoose_1.default.Types.ObjectId(findInputFile === null || findInputFile === void 0 ? void 0 : findInputFile._id),
        });
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, "Out-Put file store successfully", saveOutPutFile);
    }
    catch (error) {
        console.log("Getting Error while store the out put file:", error);
        logger_service_1.logger.error(`Getting Error while store the out put file: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.exportOutPutFile = exportOutPutFile;
// =========================== GET ALL OUT-PUT FILE =========================== /
const getAllOutPutFile = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c;
    try {
        const { take, page, search, isBatch } = req.query;
        delete req.query.take;
        delete req.query.page;
        delete req.query.search;
        delete req.query.isBatch;
        if (req.user.userType != "USER") {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.insufficient_Permissions);
        }
        // PAGINATION
        const takePerPage = Number(take) || 10;
        let pageCount = Number(page) || 1;
        if (pageCount == 0) {
            pageCount = 1;
        }
        const skip = (pageCount - 1) * takePerPage;
        // Create QUERY
        let query = {};
        // GLOBAL FILTER
        if (search) {
            query = Object.assign(Object.assign({}, query), { $and: [
                    {
                        $or: [
                            { "file.fileName": { $regex: search, $options: "i" } },
                            { batchName: { $regex: search, $options: "i" } },
                        ],
                    },
                ], userId: new mongoose_1.default.Types.ObjectId((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id) });
        }
        if (isBatch === "true") {
            query.batchName = { $ne: null };
        }
        else if (isBatch === "false") {
            query.batchName = { $eq: null };
        }
        const fileInputResponse = yield outPutFileSchema_1.outPutFile.aggregate([
            {
                $match: query,
            },
            {
                $sort: {
                    createdAt: -1,
                },
            },
            {
                $match: {
                    userId: new mongoose_1.default.Types.ObjectId((_b = req === null || req === void 0 ? void 0 : req.user) === null || _b === void 0 ? void 0 : _b._id),
                },
            },
            {
                $facet: {
                    metadata: [{ $count: "totalCount" }],
                    data: [{ $skip: skip }, { $limit: takePerPage }],
                },
            },
        ]);
        const metadata = fileInputResponse[0].metadata[0];
        const totalCount = metadata ? metadata.totalCount : 0;
        // PAGINATION
        const totalPages = Math.ceil(totalCount / takePerPage);
        const nextPage = pageCount < totalPages ? pageCount + 1 : null;
        const prevPage = pageCount > 1 ? pageCount - 1 : null;
        const responseData = {
            docs: ((_c = fileInputResponse[0]) === null || _c === void 0 ? void 0 : _c.data) || [],
            count: totalCount,
            pages: totalPages,
            currentPage: Number(page),
            nextPage,
            prevPage,
        };
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, "Out-Put Files data fetch successfully.", responseData);
    }
    catch (error) {
        console.log("Getting Error while get the all out put file:", error);
        logger_service_1.logger.error(`Getting Error while get the all out put file: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.getAllOutPutFile = getAllOutPutFile;
// =========================== DELETE OUTPUT FILE & BATCH =========================== /
const deleteOutPutFiles = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        if (!Array.isArray(req.body.ids) ||
            req.body.ids.length === 0 ||
            req.body.ids.every((id) => id === null)) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Please select files to delete.");
        }
        const _fileIds = req.body.ids.map((id) => new mongoose_1.default.Types.ObjectId(id));
        // Find all documents containing the files with the given IDs
        const documents = yield outPutFileSchema_1.outPutFile.find({ "file._id": { $in: _fileIds } });
        if (!documents || documents.length === 0) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "No files found.");
        }
        for (const doc of documents) {
            const fileArray = doc.file;
            // Filter out the files to be deleted
            const updatedFileArray = fileArray.filter((file) => !_fileIds.some((fileId) => fileId.equals(file._id)));
            // If no files are left after deletion, delete the entire document
            if (updatedFileArray.length === 0) {
                yield outPutFileSchema_1.outPutFile.deleteOne({ _id: doc._id });
            }
            else {
                // Update the document with the remaining files
                yield outPutFileSchema_1.outPutFile.updateOne({ _id: doc._id }, { $set: { file: updatedFileArray } });
            }
        }
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, "Selected files deleted successfully.");
    }
    catch (error) {
        console.log("Error while deleting the files:", error);
        logger_service_1.logger.error(`Error while deleting the files: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.deleteOutPutFiles = deleteOutPutFiles;
// =========================== THEMATIC ANALYTIC =========================== /
const thematicAnalytic = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    try {
        const openai = new openai_1.default({
            apiKey: process.env.THEMATIC_ANALYTIC_KEY,
        });
        const { _id, content } = req.body;
        if (!_id) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Id is required.");
        }
        for (let index = 0; index < content.length; index++) {
            const element = content[index];
            let len = element.length;
            if (len > 128000) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Your request entity too large.");
            }
        }
        if (!content) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Content is required.");
        }
        /* const combinedText = content.join("\n\n---\n\n");
        const promptString = `${prompt}:\n\n${combinedText}`;
    
        const response = await openai.chat.completions.create({
          model: "gpt-4o-mini",
          messages: [
            {
              role: "system",
              content: "You are a helpful assistant for thematic analysis.",
            },
            { role: "user", content: promptString },
          ],
          max_tokens: 500,
          temperature: 0.3,
        }); */
        const response = yield openai.chat.completions.create({
            model: "chatgpt-4o-latest",
            messages: [...content],
            max_tokens: 16383,
            temperature: 0.3,
            top_p: 1.0,
            frequency_penalty: 0.0,
            presence_penalty: 0.0,
        });
        if (response.choices[0].message.content.trim()) {
            yield thematicAnalysisSchema_1.thematicAnalysis.create({
                mediaId: new mongoose_1.default.Types.ObjectId(_id),
                userId: new mongoose_1.default.Types.ObjectId((_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id),
                response: response.choices[0].message.content.trim(),
            });
        }
        return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, response.choices[0].message.content.trim());
    }
    catch (error) {
        console.log("Getting error while thematic analytic processing", error);
        logger_service_1.logger.error(`Getting error while thematic analytic processing: ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.thematicAnalytic = thematicAnalytic;
// async function checkDeepgramUsages(requestId: string) {
//   try {
//     const url = `https://api.deepgram.com/v1/projects/${process.env.DEEPGRAM_PROJECT_ID}/requests/${requestId}`;
//     const options = {
//       method: "GET",
//       headers: {
//         accept: "application/json",
//         Authorization: `Token ${process.env.DEEPGRAM_KEY}`,
//       },
//     };
//     const response = await fetch(url, options);
//     const json = await response.json();
//     const usd = json.response.details.usd;
//     return { StatusCode: StatusCode.Ok, data: usd };
//   } catch (error) {
//     console.log("Getting error while checking deepgram usage", error);
//     logger.error(`Getting error while checking deepgram usage: ${error}`);
//     throw new Error("Getting error while checking deepgram usage");
//   }
// }
function checkDeepgramUsages(requestId_1) {
    return __awaiter(this, arguments, void 0, function* (requestId, retries = 2) {
        var _a, _b, _c;
        try {
            const url = `https://api.deepgram.com/v1/projects/${process.env.DEEPGRAM_PROJECT_ID}/requests/${requestId}`;
            const options = {
                method: "GET",
                headers: {
                    accept: "application/json",
                    Authorization: `Token ${process.env.DEEPGRAM_KEY}`,
                },
            };
            const response = yield fetch(url, options);
            const json = yield response.json();
            if ((json === null || json === void 0 ? void 0 : json.response) &&
                ((_a = json === null || json === void 0 ? void 0 : json.response) === null || _a === void 0 ? void 0 : _a.details) &&
                ((_c = (_b = json === null || json === void 0 ? void 0 : json.response) === null || _b === void 0 ? void 0 : _b.details) === null || _c === void 0 ? void 0 : _c.usd)) {
                const usd = json.response.details.usd;
                return { StatusCode: api_response_1.StatusCode.Ok, data: usd };
            }
            // Retry logic if details are undefined and retries are left
            if (retries > 0) {
                console.log(`Retrying Deepgram request, retries left: ${retries}`);
                yield new Promise((resolve) => setTimeout(resolve, 2000)); // Wait before retry
                return yield checkDeepgramUsages(requestId, retries - 1);
            }
            throw new Error("Deepgram usage details are unavailable after retries.");
        }
        catch (error) {
            console.log("Getting error while checking deepgram usage", error);
            logger_service_1.logger.error(`Getting error while checking deepgram usage: ${error}`);
            throw new Error("Getting error while checking deepgram usage");
        }
    });
}
function openAIResponse(content, isFlag) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const openai = new openai_1.default({
                apiKey: process.env.THEMATIC_ANALYTIC_KEY || "",
            });
            let contentMsg = [];
            if (isFlag === "summary") {
                contentMsg = [
                    {
                        role: "user",
                        content: `${content}\n You are ChatGPT-4o-latest, a large language model trained by OPENAI, based on chatgpt-4o-latest architecture. I have pasted transcribed notes from 1 message/speech below. Your task is to do a detailed review of the notes and summarize the message/speech calling out key references.`,
                    },
                ];
            }
            else if (isFlag === "keyThemes") {
                contentMsg = [
                    {
                        role: "user",
                        content: `${content}\n You are ChatGPT-4o-latest, a large language model trained by OPENAI, based on chatgpt-4o-latest architecture. I have pasted transcribed notes from 1 message/speech below. Your task is to do a detailed review of the notes and give key themes with references in a tabular format.`,
                    },
                ];
            }
            const response = yield openai.chat.completions.create({
                model: "chatgpt-4o-latest",
                messages: contentMsg,
                max_tokens: 16383,
                temperature: 0.3,
                top_p: 1.0,
                frequency_penalty: 0.0,
                presence_penalty: 0.0,
            });
            return { StatusCode: api_response_1.StatusCode.Ok, data: response };
        }
        catch (error) {
            console.log("Getting error while openAI API is processing", error);
            logger_service_1.logger.error(`Getting error while openAI API is processing: ${error}`);
            throw new Error("Getting error while openAI API is processing");
        }
    });
}
const addRecordedFile = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    try {
        const { model, transcriptionId, isRecorded, workspaceId } = req.body;
        if (!workspaceId) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.workspace.workspaceNotFound);
        }
        if (req.user.userType != utills_1.USER_TYPE.USER) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.insufficient_Permissions);
        }
        if (!req.files) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        if (req.files[0].size > 209715200) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Failed to upload file, Your file is larger than the 200MB size limit.");
        }
        const duration = yield (0, get_video_duration_1.getVideoDurationInSeconds)(req.files[0].path);
        const deepgramResponse = yield postDataToDeepgram(req.files[0].path.replace(/\\/g, "/"), model);
        // const fileName = req.files[0].path.replace("public/", process.env.FILE_URL);
        const fileName = req.files[0].path.replace(/^public[\\/]/, "");
        const thumbnailURL = yield takeScreenshot(req.files[0].path);
        if (deepgramResponse.StatusCode === api_response_1.StatusCode.Ok) {
            const deepgramUsages = yield checkDeepgramUsages((_b = (_a = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _a === void 0 ? void 0 : _a.metadata) === null || _b === void 0 ? void 0 : _b.request_id);
            const deepgramTranscript = (_g = (_f = (_e = (_d = (_c = deepgramResponse === null || deepgramResponse === void 0 ? void 0 : deepgramResponse.data) === null || _c === void 0 ? void 0 : _c.results) === null || _d === void 0 ? void 0 : _d.channels[0]) === null || _e === void 0 ? void 0 : _e.alternatives[0]) === null || _f === void 0 ? void 0 : _f.transcript) !== null && _g !== void 0 ? _g : "";
            // const summaryResponse = await openAIResponse(
            //   deepgramTranscript,
            //   "summary"
            // );
            // const keyThemesResponse = await openAIResponse(`
            //   deepgramTranscript,
            //   "keyThemes"
            // );
            const createInputFile = yield input_file_entity_1.inputFile.create({
                file: {
                    _id: new mongoose_1.default.Types.ObjectId(),
                    fileName: req.files[0].originalname,
                    // duration: duration ? duration.toFixed(2) : 0,
                    duration: duration,
                    model: model,
                    status: "Completed",
                    fileURL: fileName,
                    thumbnailURL,
                    deepgram: deepgramResponse.data,
                    // summary: summaryResponse.data.choices[0].message.content.trim(),
                    // keyThemes: keyThemesResponse.data.choices[0].message.content.trim(),
                },
                amount: Number(deepgramUsages.data.toFixed(0, 3)),
                userId: new mongoose_1.default.Types.ObjectId((_h = req === null || req === void 0 ? void 0 : req.user) === null || _h === void 0 ? void 0 : _h._id), //THIS CAN BE REMOVED
                // NEW ADDITIONS IN CONTENT PRO
                isRecorded,
                workspaceId,
                owner: new mongoose_1.default.Types.ObjectId((_j = req === null || req === void 0 ? void 0 : req.user) === null || _j === void 0 ? void 0 : _j._id), // OWNER OF FILE
                users: [new mongoose_1.default.Types.ObjectId((_k = req === null || req === void 0 ? void 0 : req.user) === null || _k === void 0 ? void 0 : _k._id)], // USERS ARRAY
            });
            const createInputFileResponse = createInputFile.toObject();
            createInputFileResponse.transcriptionId = transcriptionId;
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, "File Upload successfully", createInputFileResponse);
        }
        else {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, "Failed to upload file.");
        }
    }
    catch (error) {
        console.log("Getting error while upload file and transcribe the file", error);
        logger_service_1.logger.error(`Getting error while upload file and transcribe the file : ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.addRecordedFile = addRecordedFile;
const takeScreenshot = (filePath) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const videoExtensions = [
            ".mp4",
            ".avi",
            ".mov",
            ".webm",
            ".mkv",
            ".flv",
            ".wmv",
            ".m4v",
        ];
        // Extract the file extension from the file path
        const fileExtension = filePath
            .slice(filePath.lastIndexOf("."))
            .toLowerCase();
        if (!videoExtensions.includes(fileExtension)) {
            return "";
        }
        const screenshotPath = yield screenshotService.takeScreenshot(
        // "public/input-file/javascript_in_100_seconds_1729231055125.webm",
        filePath, "public/screenshots", 5 // Take screenshot at 5 seconds
        );
        let fullPath = "screenshots/" + screenshotPath;
        return fullPath;
    }
    catch (error) {
        console.log("Getting error while taking screenshot for video", error);
        logger_service_1.logger.error(`Getting error while taking screenshot for video : ${error}`);
    }
});
