"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sanitizeFileName = sanitizeFileName;
exports.uploadSingle = uploadSingle;
exports.uploadMultiple = uploadMultiple;
exports.uploadMultipleFile = uploadMultipleFile;
const multer_1 = __importDefault(require("multer"));
// Function to configure the storage engine
function configureStorage(folder) {
    return multer_1.default.diskStorage({
        destination: function (req, file, cb) {
            cb(null, folder);
        },
        // filename: function (req: Request, file, cb) {
        //   const uniqueSuffix = Date.now();
        //   const originalName = file.originalname;
        //   const fileName = sanitizeFileName(originalName);
        //   const extension = originalName.substring(originalName.lastIndexOf("."));
        //   cb(null, `${uniqueSuffix}_${fileName}.${extension}`);
        // },
        filename: function (req, file, cb) {
            const originalNameWithoutSpaces = file.originalname.replace(/\s+/g, "_"); // Replace spaces with underscores
            const uniqueSuffix = Date.now(); // Add timestamp and random number for uniqueness
            const fileExtension = originalNameWithoutSpaces.split(".").pop(); // Get file extension
            const fileName = sanitizeFileName(originalNameWithoutSpaces.split(".")[0]); // Remove extension from original name
            cb(null, `${fileName}_${uniqueSuffix}.${fileExtension}`); // Rebuild file name with uniqueness
        },
    });
}
function sanitizeFileName(fileName) {
    return fileName.replace(/[^a-zA-Z0-9]/g, "_").replace(/-/g, "");
}
// Function to configure storage when using the original file name
function configureStorageForInputFile(folder) {
    return multer_1.default.diskStorage({
        destination: function (req, file, cb) {
            cb(null, folder);
        },
        filename: function (req, file, cb) {
            const originalNameWithoutSpaces = file.originalname.replace(/\s+/g, "_"); // Replace spaces with underscores
            const uniqueSuffix = Date.now(); // Add timestamp and random number for uniqueness
            const fileExtension = originalNameWithoutSpaces.split(".").pop(); // Get file extension
            const fileName = sanitizeFileName(originalNameWithoutSpaces.split(".")[0]); // Remove extension from original name
            cb(null, `${fileName}_${uniqueSuffix}.${fileExtension}`); // Rebuild file name with uniqueness
        },
    });
}
// Function to handle single file upload
function uploadSingle(folder, keyName) {
    return (0, multer_1.default)({ storage: configureStorage(folder) }).single(keyName);
}
// Function to handle multiple file uploads with a maximum count
function uploadMultiple(folder, keyName, maxCount) {
    return (0, multer_1.default)({ storage: configureStorage(folder) }).array(keyName, maxCount);
}
// Function to handle multiple file uploads with file size limit and original name preservation
function uploadMultipleFile(folder, keyName, maxCount) {
    return (0, multer_1.default)({
        storage: configureStorageForInputFile(folder),
        limits: {
            fileSize: 1024 * 1024 * 200, // 200MB size limit for each file
        },
    }).array(keyName, maxCount);
}
