"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCompanySetting = getCompanySetting;
exports.updateCompanySetting = updateCompanySetting;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const company_settings_entity_1 = __importDefault(require("../entities/company-settings.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//====================== GET COMPANY SETTING ====================/
function getCompanySetting(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const data = yield company_settings_entity_1.default.find();
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, data);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get company setting : ${error}`);
            console.log("Getting error while get company setting :", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//====================== UPDATE A COMPANY SETTING ====================/
function updateCompanySetting(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { companyName, emailId, mobileNumber, url, _id, companyAddress } = req.body;
        let companyImage = ((_a = req === null || req === void 0 ? void 0 : req.body) === null || _a === void 0 ? void 0 : _a.companyImage) || null;
        if ((_b = req === null || req === void 0 ? void 0 : req.files) === null || _b === void 0 ? void 0 : _b.companyImage) {
            companyImage = (_d = (_c = req === null || req === void 0 ? void 0 : req.files) === null || _c === void 0 ? void 0 : _c.companyImage[0]) === null || _d === void 0 ? void 0 : _d.filename;
        }
        const updatedCompanySettingData = {
            companyName,
            emailId,
            companyAddress,
            mobileNumber,
            url,
            companyImage,
        };
        try {
            if (companyImage) {
                updatedCompanySettingData.companyImage = companyImage;
            }
            const updatedCompanySetting = yield company_settings_entity_1.default.findByIdAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id) }, Object.assign({}, updatedCompanySettingData), { new: true });
            if (!updatedCompanySetting) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.companySetting.companySettingNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.companySetting.companySettingpUpdated, updatedCompanySetting);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while updated company setting : ${error}`);
            console.log(`Getting error while updated company setting : ${error}`);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
