"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateFile = validateFile;
const common_service_1 = require("../service/common.service");
const api_response_1 = require("../api.response");
const logger_service_1 = require("../service/logger.service");
//***************** FILE VALIDATION *******************//
function validateFile(req, res, next) {
    var _a;
    try {
        if (((_a = req === null || req === void 0 ? void 0 : req.isValid) === null || _a === void 0 ? void 0 : _a.isValid) === false) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, req.isValid.message);
        }
        next();
    }
    catch (error) {
        console.log("Getting error while check file validation:", error);
        logger_service_1.logger.error(`Getting error while check file validation : ${error}`);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.error);
    }
}
