"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addSubscription = addSubscription;
exports.updateSubscription = updateSubscription;
exports.getSubscriptions = getSubscriptions;
exports.deleteSubscription = deleteSubscription;
exports.getSubscriptionById = getSubscriptionById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../../src/api.response");
const subscription_entity_1 = __importDefault(require("../entities/subscription.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//======================= ADD A NEW SUBSCRIPTION ===============/
function addSubscription(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { subscriptionTitle, status, planDuration, subscriptionAmount, startDate, endDate, subscriptionContent, } = req.body;
        if (!subscriptionTitle ||
            !planDuration ||
            !subscriptionAmount ||
            !startDate ||
            !endDate ||
            !subscriptionContent) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingSubscription = yield subscription_entity_1.default.findOne({
                subscriptionTitle,
                isDeleted: false,
            });
            if (existingSubscription) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.subscription.subscriptionExits);
            }
            else {
                const savedSubscription = yield subscription_entity_1.default.create({
                    subscriptionTitle,
                    planDuration,
                    subscriptionAmount,
                    startDate,
                    endDate,
                    status,
                    subscriptionContent,
                });
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.subscription.success, savedSubscription);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add subscription: ${error}`);
            console.log("Getting error while add subscription: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//======================= UPDATE AN EXISTING SUBSCRIPTION ===============/
function updateSubscription(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { subscriptionTitle, planDuration, subscriptionAmount, startDate, endDate, status, subscriptionContent, _id, } = req.body;
        try {
            const updatedSubscriptionQuality = yield subscription_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, {
                subscriptionTitle,
                planDuration,
                subscriptionAmount,
                startDate,
                endDate,
                status,
                subscriptionContent,
            }, { new: true });
            if (!updatedSubscriptionQuality) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.subscription.subscriptionNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.subscription.subscriptionUpdated, updatedSubscriptionQuality);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while update subscription: ${error}`);
            console.log("Getting error while update subscription:", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//======================= GET ALL SUBSCRIPTION ===============/
function getSubscriptions(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take, role } = query;
            const searchQuery = search
                ? {
                    $or: [
                        { subscriptionTitle: new RegExp(search, "i") },
                        { planDuration: new RegExp(search, "i") },
                    ],
                }
                : {};
            let filters = { isDeleted: false };
            if (role)
                filters.role = role;
            const options = {
                searchQuery,
                filter: filters,
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: subscriptions, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(subscription_entity_1.default, options);
            if (!subscriptions.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: subscriptions || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get subscriptions list : ${error}`);
            console.log("Getting error while get subscriptions list : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//======================= DELETE A SUBSCRIPTION ===============/
function deleteSubscription(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield subscription_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(id), isDeleted: false }, { isDeleted: true });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.subscription.subscriptionDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while delete subscription : ${error}`);
            console.log("Getting error while delete subscription : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//======================= GET SUBSCRIPTION BY ID ===============/
function getSubscriptionById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const subscription = yield subscription_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!subscription) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.subscription.subscriptionNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, subscription);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get subscription by id: ${error}`);
            console.log("Getting error while get subscription by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
