"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validFileType = exports.fetchWithAggregationAndPagination = exports.convertUrlToTitle = exports.fetchUsersWithFilterAndPagination = exports.getTokenUserInfo = void 0;
exports.sendDataResponse = sendDataResponse;
exports.sendMessageResponse = sendMessageResponse;
exports.sendTokenResponse = sendTokenResponse;
exports.sendValidationMessageResponse = sendValidationMessageResponse;
exports.getMediaDuration = getMediaDuration;
exports.downloadVideo = downloadVideo;
const api_response_1 = require("../api.response");
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const dotenv_1 = __importDefault(require("dotenv"));
const fs = __importStar(require("fs"));
const node_child_process_1 = require("node:child_process");
dotenv_1.default.config();
const secret_key = process.env.JWT_SECRET || "";
//***************** SEND RESPONSE *******************//
const logger_service_1 = require("./logger.service");
function sendDataResponse(req, res, status, message, data) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            return res.status(status).json({
                StatusCode: status,
                message: message,
                data: data,
            });
        }
        catch (err) {
            console.log("Getting error while send data response common service function:", err);
            logger_service_1.logger.error(`Getting error while data send response common service function : ${err}`);
            return yield sendMessageResponse(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.InternalServerError, api_response_1.messages === null || api_response_1.messages === void 0 ? void 0 : api_response_1.messages.error);
        }
    });
}
function sendMessageResponse(req, res, status, message) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            return res.status(status).json({
                StatusCode: status,
                message: message,
            });
        }
        catch (err) {
            console.log("Getting error while send message response common service function:", err);
            logger_service_1.logger.error(`Getting error while send message response common service function : ${err}`);
            return res.status(status).json({
                StatusCode: api_response_1.StatusCode.InternalServerError,
                message: api_response_1.messages.error,
            });
        }
    });
}
function sendTokenResponse(req, res, status, message, data, token) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            return res.status(status).json({
                StatusCode: status,
                message: message,
                data: data,
                token: token,
            });
        }
        catch (err) {
            console.log("Getting error while send token response common service function:", err);
            logger_service_1.logger.error(`Getting error while send token response common service function : ${err}`);
            return yield sendMessageResponse(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.InternalServerError, api_response_1.messages === null || api_response_1.messages === void 0 ? void 0 : api_response_1.messages.error);
        }
    });
}
function sendValidationMessageResponse(req, res, status, message) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            return res.status(status).json({
                StatusCode: status,
                message: message,
            });
        }
        catch (err) {
            console.log("Getting error while send message response common service function:", err);
            logger_service_1.logger.error(`Getting error while send message response common service function : ${err}`);
            return res.status(status).json({
                StatusCode: api_response_1.StatusCode.InternalServerError,
                message: api_response_1.messages.error,
            });
        }
    });
}
const getTokenUserInfo = (req) => {
    try {
        const authHeader = req.headers["authorization"];
        if (!authHeader) {
            throw new Error("Authorization header is missing");
        }
        const token = authHeader.split(" ")[1]; // Assuming JWT format "Bearer token"
        if (!token) {
            throw new Error("Authorization token is missing");
        }
        const decoded = jsonwebtoken_1.default.verify(token, secret_key);
        return decoded;
    }
    catch (error) {
        throw error; // Re-throw the error for proper handling
    }
};
exports.getTokenUserInfo = getTokenUserInfo;
const fetchUsersWithFilterAndPagination = (model, options) => __awaiter(void 0, void 0, void 0, function* () {
    const { searchQuery = {}, filter = {}, page = 1, take = 10 } = options;
    try {
        const combinedQuery = Object.assign(Object.assign({}, searchQuery), filter);
        const totalMatchedDocuments = yield model.countDocuments(combinedQuery);
        // Ensure page is at least 1
        const maxPage = Math.ceil(totalMatchedDocuments / take);
        const adjustedPage = Math.max(1, Math.min(page, maxPage));
        const skip = (adjustedPage - 1) * take;
        const data = yield model.find(combinedQuery).skip(skip).limit(take);
        const totalPages = Math.ceil(totalMatchedDocuments / take);
        const nextPage = adjustedPage < totalPages ? adjustedPage + 1 : null;
        const prevPage = adjustedPage > 1 ? adjustedPage - 1 : null;
        return {
            data,
            nextPage,
            page: adjustedPage,
            prevPage,
            take: take,
            totalData: totalMatchedDocuments,
            totalPages,
        };
    }
    catch (error) {
        throw new Error(`Error fetching users: ${error === null || error === void 0 ? void 0 : error.message}`);
    }
});
exports.fetchUsersWithFilterAndPagination = fetchUsersWithFilterAndPagination;
const convertUrlToTitle = (url) => {
    const cleanUrl = url.split("?")[0];
    const parts = cleanUrl.split("/").filter((part) => {
        return !/^[0-9a-fA-F]{24}$/.test(part);
    });
    const formattedTitle = parts
        .map((part) => {
        if (part.includes("-")) {
            return part
                .split("-")
                .map((word) => word.charAt(0).toUpperCase() + word.slice(1))
                .join(" ");
        }
        return part.charAt(0).toUpperCase() + part.slice(1);
    })
        .join(" ");
    return formattedTitle;
};
exports.convertUrlToTitle = convertUrlToTitle;
const fetchWithAggregationAndPagination = (model, // Use model instead of collection name
options) => __awaiter(void 0, void 0, void 0, function* () {
    const { pipeline = [], page = 1, take = 10 } = options;
    try {
        // Calculate skip and limit based on page and take
        const skip = (page - 1) * take;
        // Add $skip and $limit to the pipeline for pagination
        const paginatedPipeline = [...pipeline, { $skip: skip }, { $limit: take }];
        // Create a separate count pipeline to get the total number of documents
        const countPipeline = [...pipeline, { $count: "total" }];
        const countResult = yield model.aggregate(countPipeline).exec();
        const totalMatchedDocuments = countResult.length ? countResult[0].total : 0;
        // Execute the paginated aggregation
        const data = yield model.aggregate(paginatedPipeline).exec();
        // Calculate pagination details
        const totalPages = Math.ceil(totalMatchedDocuments / take);
        const nextPage = page < totalPages ? page + 1 : null;
        const prevPage = page > 1 ? page - 1 : null;
        return {
            data,
            pagination: {
                nextPage,
                page,
                prevPage,
                take,
                totalData: totalMatchedDocuments,
                totalPages,
            },
        };
    }
    catch (error) {
        throw new Error(`Error fetching data with aggregation: ${error === null || error === void 0 ? void 0 : error.message}`);
    }
});
exports.fetchWithAggregationAndPagination = fetchWithAggregationAndPagination;
//====================================== IMAGE VALIDATOR ===========================================//
const validFileType = (req, res, next) => {
    try {
        const mime = [
            "video/mp4",
            "video/webm",
            "video/avi",
            "video/*",
            "video/quicktime",
            "audio/mpeg",
            "audio/mp3",
        ];
        const mimeTypes = [];
        // check for the mimetypes of files
        for (const key in req.files) {
            if (req.files[key]) {
                let filesArray = req.files[key];
                // If it's not an array, convert it into an array
                if (!Array.isArray(filesArray)) {
                    filesArray = [filesArray];
                }
                filesArray.forEach((file) => {
                    const mimeType = file.mimetype;
                    mimeTypes.push(mimeType);
                });
            }
        }
        let allMatched = mimeTypes.every((mimetype) => mime.includes(mimetype));
        // if the mimetype does not match the allowed mimetypes, then delete the files
        if (!allMatched) {
            for (const key in req.files) {
                if (req.files[key]) {
                    let filesArray = req.files[key];
                    // Convert to array if it's not
                    if (!Array.isArray(filesArray)) {
                        filesArray = [filesArray];
                    }
                    filesArray.forEach((file) => {
                        fs.unlink(file.path, (err) => {
                            if (err) {
                                console.error("Error deleting file:", err);
                            }
                        });
                    });
                }
            }
            return res.status(400).send({
                statuscode: 400,
                message: "Invalid file type",
            });
        }
        next();
    }
    catch (error) {
        // handle the server errors if any
        console.log("error while validating file", error);
        return res.status(400).send({
            statuscode: 400,
            message: "Invalid file type",
        });
    }
};
exports.validFileType = validFileType;
//================ GET MEDIA DURATION ============================
function getMediaDuration(filePath) {
    return new Promise((resolve, reject) => {
        (0, node_child_process_1.execFile)("ffprobe", [
            "-v",
            "error",
            "-show_entries",
            "format=duration",
            "-of",
            "default=noprint_wrappers=1:nokey=1",
            filePath,
        ], (error, stdout, stderr) => {
            if (error) {
                reject(`Error getting duration: ${error.message}`);
                return;
            }
            const duration = parseFloat(stdout);
            resolve(duration);
        });
    });
}
//================ Download Video from YOUTUBE URL======================
function downloadVideo(url, tempName) {
    // Construct the yt-dlp command
    // const tempName = Date.now();
    const command = `yt-dlp -o "public/input-file/${tempName}.%(ext)s" "${url}"`;
    return new Promise((resolve, reject) => {
        (0, node_child_process_1.exec)(command, (error, stdout, stderr) => {
            if (error) {
                reject(error);
                return;
            }
            // if (stderr) {
            //   console.error("Command output:", stderr);
            // }
            // console.log("Download output:", stdout);
            resolve(stdout);
        });
    });
}
