"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importDefault(require("mongoose"));
const utills_1 = require("../../../src/service/utills");
const notificationSchema = new mongoose_1.default.Schema({
    title: {
        type: String,
        required: true,
    },
    groupId: {
        type: mongoose_1.default.Types.ObjectId,
        ref: "group",
        required: function () {
            return this.notificationType === utills_1.notification.group_notification;
        },
    },
    userId: {
        type: mongoose_1.default.Types.ObjectId,
        ref: "users",
        required: function () {
            return this.notificationType === utills_1.notification.individual_notification;
        },
    },
    message: {
        type: String,
        required: true,
    },
    notificationType: {
        type: String,
        enum: [
            utills_1.notification.group_notification,
            utills_1.notification.individual_notification,
            utills_1.notification.all_users,
        ],
        required: true,
    },
    isDeleted: {
        type: Boolean,
        default: false,
    },
}, {
    timestamps: true,
});
exports.default = mongoose_1.default.model("notification", notificationSchema);
