"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addFaqs = addFaqs;
exports.updateFaqs = updateFaqs;
exports.getFaqs = getFaqs;
exports.deleteFaqs = deleteFaqs;
exports.getFaqsById = getFaqsById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const faqs_entity_1 = __importDefault(require("../entities/faqs.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//==================== ADD NEW FAQs =========================/
function addFaqs(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { title, subTitle, description, status } = req.body;
        if (!title) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingFaqs = yield faqs_entity_1.default.findOne({ title });
            if (existingFaqs) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.faqs.faqExits);
            }
            else {
                const newFaqsData = new faqs_entity_1.default({
                    title,
                    subTitle,
                    description,
                    status,
                });
                const savedFaqsData = yield newFaqsData.save();
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.faqs.success, savedFaqsData);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add faqs : ${error}`);
            console.log("Getting error while add faqs : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== UPDATE AN EXISTING FAQs =========================/
function updateFaqs(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { title, subTitle, description, status, _id } = req.body;
        try {
            const updatedFaqs = yield faqs_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { title, subTitle, description, status }, { new: true });
            if (!updatedFaqs) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.faqs.faqNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.faqs.faqUpdated, updatedFaqs);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  update faqs : ${error}`);
            console.log("Getting error while  update faqs : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET ALL FAQs =========================/
function getFaqs(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take } = query;
            const searchQuery = search
                ? { title: new RegExp(search, "i") }
                : {};
            const options = {
                searchQuery,
                filter: {},
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(faqs_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: data || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while fetching FAQs: ${error}`);
            console.log("Getting error while fetching FAQs:", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== DELETE A FAQs =========================/
function deleteFaqs(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield faqs_entity_1.default.findOneAndDelete({
                _id: new mongoose_1.default.Types.ObjectId(id),
                isDeleted: false,
            });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.faqs.faqDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  delete faqs : ${error}`);
            console.log("Getting error while  delete faqs : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET FAQs BY ID =========================/
function getFaqsById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const faq = yield faqs_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!faq) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.faqs.faqNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, faq);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  get faq by id : ${error}`);
            console.error("Getting error while  get faq by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
